package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  DataSchema,
  Message,
  Recipe,
  ScoreThreshold,
  S3Url,
  MLModelName,
  EpochTime,
  EntityId,
  LongType,
  PresignedS3Url,
  AwsUserArn,
  StringType
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetMlModelResponse(
    mlModelId: Option[EntityId] = None,
    trainingDataSourceId: Option[EntityId] = None,
    createdByIamUser: Option[AwsUserArn] = None,
    createdAt: Option[EpochTime] = None,
    lastUpdatedAt: Option[EpochTime] = None,
    name: Option[MLModelName] = None,
    status: Option[zio.aws.machinelearning.model.EntityStatus] = None,
    sizeInBytes: Option[LongType] = None,
    endpointInfo: Option[zio.aws.machinelearning.model.RealtimeEndpointInfo] =
      None,
    trainingParameters: Option[Map[StringType, StringType]] = None,
    inputDataLocationS3: Option[S3Url] = None,
    mlModelType: Option[zio.aws.machinelearning.model.MLModelType] = None,
    scoreThreshold: Option[ScoreThreshold] = None,
    scoreThresholdLastUpdatedAt: Option[EpochTime] = None,
    logUri: Option[PresignedS3Url] = None,
    message: Option[Message] = None,
    computeTime: Option[LongType] = None,
    finishedAt: Option[EpochTime] = None,
    startedAt: Option[EpochTime] = None,
    recipe: Option[Recipe] = None,
    schema: Option[DataSchema] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetMlModelResponse = {
    import GetMlModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetMlModelResponse
      .builder()
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .optionallyWith(
        trainingDataSourceId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.trainingDataSourceId)
      .optionallyWith(
        createdByIamUser.map(value =>
          AwsUserArn.unwrap(value): java.lang.String
        )
      )(_.createdByIamUser)
      .optionallyWith(createdAt.map(value => EpochTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => MLModelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sizeInBytes.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.sizeInBytes)
      .optionallyWith(endpointInfo.map(value => value.buildAwsValue()))(
        _.endpointInfo
      )
      .optionallyWith(
        trainingParameters.map(value =>
          value
            .map({ case (key, value) =>
              (StringType.unwrap(key): java.lang.String) -> (StringType.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.trainingParameters)
      .optionallyWith(
        inputDataLocationS3.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.inputDataLocationS3)
      .optionallyWith(mlModelType.map(value => value.unwrap))(_.mlModelType)
      .optionallyWith(
        scoreThreshold.map(value =>
          ScoreThreshold.unwrap(value): java.lang.Float
        )
      )(_.scoreThreshold)
      .optionallyWith(
        scoreThresholdLastUpdatedAt.map(value =>
          EpochTime.unwrap(value): Instant
        )
      )(_.scoreThresholdLastUpdatedAt)
      .optionallyWith(
        logUri.map(value => PresignedS3Url.unwrap(value): java.lang.String)
      )(_.logUri)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        computeTime.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.computeTime)
      .optionallyWith(
        finishedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.finishedAt)
      .optionallyWith(startedAt.map(value => EpochTime.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        recipe.map(value => Recipe.unwrap(value): java.lang.String)
      )(_.recipe)
      .optionallyWith(
        schema.map(value => DataSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.GetMlModelResponse.ReadOnly =
    zio.aws.machinelearning.model.GetMlModelResponse.wrap(buildAwsValue())
}
object GetMlModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetMlModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetMlModelResponse =
      zio.aws.machinelearning.model.GetMlModelResponse(
        mlModelId.map(value => value),
        trainingDataSourceId.map(value => value),
        createdByIamUser.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        status.map(value => value),
        sizeInBytes.map(value => value),
        endpointInfo.map(value => value.asEditable),
        trainingParameters.map(value => value),
        inputDataLocationS3.map(value => value),
        mlModelType.map(value => value),
        scoreThreshold.map(value => value),
        scoreThresholdLastUpdatedAt.map(value => value),
        logUri.map(value => value),
        message.map(value => value),
        computeTime.map(value => value),
        finishedAt.map(value => value),
        startedAt.map(value => value),
        recipe.map(value => value),
        schema.map(value => value)
      )
    def mlModelId: Option[EntityId]
    def trainingDataSourceId: Option[EntityId]
    def createdByIamUser: Option[AwsUserArn]
    def createdAt: Option[EpochTime]
    def lastUpdatedAt: Option[EpochTime]
    def name: Option[MLModelName]
    def status: Option[zio.aws.machinelearning.model.EntityStatus]
    def sizeInBytes: Option[LongType]
    def endpointInfo
        : Option[zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly]
    def trainingParameters: Option[Map[StringType, StringType]]
    def inputDataLocationS3: Option[S3Url]
    def mlModelType: Option[zio.aws.machinelearning.model.MLModelType]
    def scoreThreshold: Option[ScoreThreshold]
    def scoreThresholdLastUpdatedAt: Option[EpochTime]
    def logUri: Option[PresignedS3Url]
    def message: Option[Message]
    def computeTime: Option[LongType]
    def finishedAt: Option[EpochTime]
    def startedAt: Option[EpochTime]
    def recipe: Option[Recipe]
    def schema: Option[DataSchema]
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
    def getTrainingDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("trainingDataSourceId", trainingDataSourceId)
    def getCreatedByIamUser: ZIO[Any, AwsError, AwsUserArn] =
      AwsError.unwrapOptionField("createdByIamUser", createdByIamUser)
    def getCreatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, MLModelName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.EntityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSizeInBytes: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
    def getEndpointInfo: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly
    ] = AwsError.unwrapOptionField("endpointInfo", endpointInfo)
    def getTrainingParameters: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("trainingParameters", trainingParameters)
    def getInputDataLocationS3: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("inputDataLocationS3", inputDataLocationS3)
    def getMlModelType
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.MLModelType] =
      AwsError.unwrapOptionField("mlModelType", mlModelType)
    def getScoreThreshold: ZIO[Any, AwsError, ScoreThreshold] =
      AwsError.unwrapOptionField("scoreThreshold", scoreThreshold)
    def getScoreThresholdLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField(
        "scoreThresholdLastUpdatedAt",
        scoreThresholdLastUpdatedAt
      )
    def getLogUri: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getComputeTime: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("computeTime", computeTime)
    def getFinishedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("finishedAt", finishedAt)
    def getStartedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getRecipe: ZIO[Any, AwsError, Recipe] =
      AwsError.unwrapOptionField("recipe", recipe)
    def getSchema: ZIO[Any, AwsError, DataSchema] =
      AwsError.unwrapOptionField("schema", schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetMlModelResponse
  ) extends zio.aws.machinelearning.model.GetMlModelResponse.ReadOnly {
    override val mlModelId: Option[EntityId] = scala
      .Option(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val trainingDataSourceId: Option[EntityId] = scala
      .Option(impl.trainingDataSourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val createdByIamUser: Option[AwsUserArn] = scala
      .Option(impl.createdByIamUser())
      .map(value => zio.aws.machinelearning.model.primitives.AwsUserArn(value))
    override val createdAt: Option[EpochTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val lastUpdatedAt: Option[EpochTime] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val name: Option[MLModelName] = scala
      .Option(impl.name())
      .map(value => zio.aws.machinelearning.model.primitives.MLModelName(value))
    override val status: Option[zio.aws.machinelearning.model.EntityStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.machinelearning.model.EntityStatus.wrap(value))
    override val sizeInBytes: Option[LongType] = scala
      .Option(impl.sizeInBytes())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val endpointInfo
        : Option[zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly] =
      scala
        .Option(impl.endpointInfo())
        .map(value =>
          zio.aws.machinelearning.model.RealtimeEndpointInfo.wrap(value)
        )
    override val trainingParameters: Option[Map[StringType, StringType]] = scala
      .Option(impl.trainingParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.machinelearning.model.primitives.StringType(
              key
            ) -> zio.aws.machinelearning.model.primitives.StringType(value)
          })
          .toMap
      )
    override val inputDataLocationS3: Option[S3Url] = scala
      .Option(impl.inputDataLocationS3())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val mlModelType
        : Option[zio.aws.machinelearning.model.MLModelType] = scala
      .Option(impl.mlModelType())
      .map(value => zio.aws.machinelearning.model.MLModelType.wrap(value))
    override val scoreThreshold: Option[ScoreThreshold] = scala
      .Option(impl.scoreThreshold())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ScoreThreshold(value)
      )
    override val scoreThresholdLastUpdatedAt: Option[EpochTime] = scala
      .Option(impl.scoreThresholdLastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val logUri: Option[PresignedS3Url] = scala
      .Option(impl.logUri())
      .map(value =>
        zio.aws.machinelearning.model.primitives.PresignedS3Url(value)
      )
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.machinelearning.model.primitives.Message(value))
    override val computeTime: Option[LongType] = scala
      .Option(impl.computeTime())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val finishedAt: Option[EpochTime] = scala
      .Option(impl.finishedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val startedAt: Option[EpochTime] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val recipe: Option[Recipe] = scala
      .Option(impl.recipe())
      .map(value => zio.aws.machinelearning.model.primitives.Recipe(value))
    override val schema: Option[DataSchema] = scala
      .Option(impl.schema())
      .map(value => zio.aws.machinelearning.model.primitives.DataSchema(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetMlModelResponse
  ): zio.aws.machinelearning.model.GetMlModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
