package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.StringType
import scala.jdk.CollectionConverters.*
final case class DescribeMlModelsResponse(
    results: Option[Iterable[zio.aws.machinelearning.model.MLModel]] = None,
    nextToken: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse = {
    import DescribeMlModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(
        nextToken.map(value => StringType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly =
    zio.aws.machinelearning.model.DescribeMlModelsResponse.wrap(buildAwsValue())
}
object DescribeMlModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DescribeMlModelsResponse =
      zio.aws.machinelearning.model.DescribeMlModelsResponse(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def results: Option[List[zio.aws.machinelearning.model.MLModel.ReadOnly]]
    def nextToken: Option[StringType]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.machinelearning.model.MLModel.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
    def getNextToken: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse
  ) extends zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly {
    override val results
        : Option[List[zio.aws.machinelearning.model.MLModel.ReadOnly]] = scala
      .Option(impl.results())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.machinelearning.model.MLModel.wrap(item)
        }.toList
      )
    override val nextToken: Option[StringType] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.machinelearning.model.primitives.StringType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse
  ): zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly =
    new Wrapper(impl)
}
