package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters.*
final case class UpdateMlModelResponse(mlModelId: Option[EntityId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.UpdateMlModelResponse = {
    import UpdateMlModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.UpdateMlModelResponse
      .builder()
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.UpdateMlModelResponse.ReadOnly =
    zio.aws.machinelearning.model.UpdateMlModelResponse.wrap(buildAwsValue())
}
object UpdateMlModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.UpdateMlModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.UpdateMlModelResponse =
      zio.aws.machinelearning.model
        .UpdateMlModelResponse(mlModelId.map(value => value))
    def mlModelId: Option[EntityId]
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateMlModelResponse
  ) extends zio.aws.machinelearning.model.UpdateMlModelResponse.ReadOnly {
    override val mlModelId: Option[EntityId] = scala
      .Option(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateMlModelResponse
  ): zio.aws.machinelearning.model.UpdateMlModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
