package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  DetailsValue,
  ScoreValue,
  FloatLabel,
  Label
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Prediction(
    predictedLabel: Optional[Label] = Optional.Absent,
    predictedValue: Optional[FloatLabel] = Optional.Absent,
    predictedScores: Optional[Map[Label, ScoreValue]] = Optional.Absent,
    details: Optional[
      Map[zio.aws.machinelearning.model.DetailsAttributes, DetailsValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.Prediction = {
    import Prediction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.Prediction
      .builder()
      .optionallyWith(
        predictedLabel.map(value => Label.unwrap(value): java.lang.String)
      )(_.predictedLabel)
      .optionallyWith(
        predictedValue.map(value => FloatLabel.unwrap(value): java.lang.Float)
      )(_.predictedValue)
      .optionallyWith(
        predictedScores.map(value =>
          value
            .map({ case (key, value) =>
              (Label.unwrap(key): java.lang.String) -> (ScoreValue
                .unwrap(value): java.lang.Float)
            })
            .asJava
        )
      )(_.predictedScores)
      .optionallyWith(
        details.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (DetailsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.detailsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.Prediction.ReadOnly =
    zio.aws.machinelearning.model.Prediction.wrap(buildAwsValue())
}
object Prediction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.Prediction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.Prediction =
      zio.aws.machinelearning.model.Prediction(
        predictedLabel.map(value => value),
        predictedValue.map(value => value),
        predictedScores.map(value => value),
        details.map(value => value)
      )
    def predictedLabel: Optional[Label]
    def predictedValue: Optional[FloatLabel]
    def predictedScores: Optional[Map[Label, ScoreValue]]
    def details: Optional[
      Map[zio.aws.machinelearning.model.DetailsAttributes, DetailsValue]
    ]
    def getPredictedLabel: ZIO[Any, AwsError, Label] =
      AwsError.unwrapOptionField("predictedLabel", predictedLabel)
    def getPredictedValue: ZIO[Any, AwsError, FloatLabel] =
      AwsError.unwrapOptionField("predictedValue", predictedValue)
    def getPredictedScores: ZIO[Any, AwsError, Map[Label, ScoreValue]] =
      AwsError.unwrapOptionField("predictedScores", predictedScores)
    def getDetails: ZIO[Any, AwsError, Map[
      zio.aws.machinelearning.model.DetailsAttributes,
      DetailsValue
    ]] = AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.Prediction
  ) extends zio.aws.machinelearning.model.Prediction.ReadOnly {
    override val predictedLabel: Optional[Label] = zio.aws.core.internal
      .optionalFromNullable(impl.predictedLabel())
      .map(value => zio.aws.machinelearning.model.primitives.Label(value))
    override val predictedValue: Optional[FloatLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.predictedValue())
      .map(value => zio.aws.machinelearning.model.primitives.FloatLabel(value))
    override val predictedScores: Optional[Map[Label, ScoreValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictedScores())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.machinelearning.model.primitives.Label(
                key
              ) -> zio.aws.machinelearning.model.primitives.ScoreValue(value)
            })
            .toMap
        )
    override val details: Optional[
      Map[zio.aws.machinelearning.model.DetailsAttributes, DetailsValue]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.machinelearning.model.DetailsAttributes.wrap(
              key
            ) -> zio.aws.machinelearning.model.primitives.DetailsValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.Prediction
  ): zio.aws.machinelearning.model.Prediction.ReadOnly = new Wrapper(impl)
}
