package zio.aws.machinelearning.model
import scala.jdk.CollectionConverters._
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.machinelearning.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.machinelearning.model.SortOrder
  ): zio.aws.machinelearning.model.SortOrder = value match {
    case software.amazon.awssdk.services.machinelearning.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.machinelearning.model.SortOrder.ASC =>
      val r = asc
      r
    case software.amazon.awssdk.services.machinelearning.model.SortOrder.DSC =>
      val r = dsc
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.machinelearning.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.SortOrder =
      software.amazon.awssdk.services.machinelearning.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object asc extends zio.aws.machinelearning.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.SortOrder =
      software.amazon.awssdk.services.machinelearning.model.SortOrder.ASC
  }
  case object dsc extends zio.aws.machinelearning.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.SortOrder =
      software.amazon.awssdk.services.machinelearning.model.SortOrder.DSC
  }
}
