package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{S3Url, EntityName, EntityId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBatchPredictionRequest(
    batchPredictionId: EntityId,
    batchPredictionName: Optional[EntityName] = Optional.Absent,
    mlModelId: EntityId,
    batchPredictionDataSourceId: EntityId,
    outputUri: S3Url
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest = {
    import CreateBatchPredictionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest
      .builder()
      .batchPredictionId(EntityId.unwrap(batchPredictionId): java.lang.String)
      .optionallyWith(
        batchPredictionName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.batchPredictionName)
      .mlModelId(EntityId.unwrap(mlModelId): java.lang.String)
      .batchPredictionDataSourceId(
        EntityId.unwrap(batchPredictionDataSourceId): java.lang.String
      )
      .outputUri(S3Url.unwrap(outputUri): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.CreateBatchPredictionRequest.ReadOnly =
    zio.aws.machinelearning.model.CreateBatchPredictionRequest
      .wrap(buildAwsValue())
}
object CreateBatchPredictionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.CreateBatchPredictionRequest =
      zio.aws.machinelearning.model.CreateBatchPredictionRequest(
        batchPredictionId,
        batchPredictionName.map(value => value),
        mlModelId,
        batchPredictionDataSourceId,
        outputUri
      )
    def batchPredictionId: EntityId
    def batchPredictionName: Optional[EntityName]
    def mlModelId: EntityId
    def batchPredictionDataSourceId: EntityId
    def outputUri: S3Url
    def getBatchPredictionId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(batchPredictionId)
    def getBatchPredictionName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("batchPredictionName", batchPredictionName)
    def getMlModelId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(mlModelId)
    def getBatchPredictionDataSourceId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(batchPredictionDataSourceId)
    def getOutputUri: ZIO[Any, Nothing, S3Url] = ZIO.succeed(outputUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest
  ) extends zio.aws.machinelearning.model.CreateBatchPredictionRequest.ReadOnly {
    override val batchPredictionId: EntityId =
      zio.aws.machinelearning.model.primitives
        .EntityId(impl.batchPredictionId())
    override val batchPredictionName: Optional[EntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchPredictionName())
        .map(value =>
          zio.aws.machinelearning.model.primitives.EntityName(value)
        )
    override val mlModelId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.mlModelId())
    override val batchPredictionDataSourceId: EntityId =
      zio.aws.machinelearning.model.primitives
        .EntityId(impl.batchPredictionDataSourceId())
    override val outputUri: S3Url =
      zio.aws.machinelearning.model.primitives.S3Url(impl.outputUri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest
  ): zio.aws.machinelearning.model.CreateBatchPredictionRequest.ReadOnly =
    new Wrapper(impl)
}
