package zio.aws.machinelearning.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.machinelearning.model.primitives.{
  Message,
  ScoreThreshold,
  S3Url,
  MLModelName,
  EpochTime,
  EntityId,
  LongType,
  AwsUserArn,
  StringType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class MLModel(
    mlModelId: Optional[EntityId] = Optional.Absent,
    trainingDataSourceId: Optional[EntityId] = Optional.Absent,
    createdByIamUser: Optional[AwsUserArn] = Optional.Absent,
    createdAt: Optional[EpochTime] = Optional.Absent,
    lastUpdatedAt: Optional[EpochTime] = Optional.Absent,
    name: Optional[MLModelName] = Optional.Absent,
    status: Optional[zio.aws.machinelearning.model.EntityStatus] =
      Optional.Absent,
    sizeInBytes: Optional[LongType] = Optional.Absent,
    endpointInfo: Optional[zio.aws.machinelearning.model.RealtimeEndpointInfo] =
      Optional.Absent,
    trainingParameters: Optional[Map[StringType, StringType]] = Optional.Absent,
    inputDataLocationS3: Optional[S3Url] = Optional.Absent,
    algorithm: Optional[zio.aws.machinelearning.model.Algorithm] =
      Optional.Absent,
    mlModelType: Optional[zio.aws.machinelearning.model.MLModelType] =
      Optional.Absent,
    scoreThreshold: Optional[ScoreThreshold] = Optional.Absent,
    scoreThresholdLastUpdatedAt: Optional[EpochTime] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    computeTime: Optional[LongType] = Optional.Absent,
    finishedAt: Optional[EpochTime] = Optional.Absent,
    startedAt: Optional[EpochTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.MLModel = {
    import MLModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.MLModel
      .builder()
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .optionallyWith(
        trainingDataSourceId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.trainingDataSourceId)
      .optionallyWith(
        createdByIamUser.map(value =>
          AwsUserArn.unwrap(value): java.lang.String
        )
      )(_.createdByIamUser)
      .optionallyWith(createdAt.map(value => EpochTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => MLModelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sizeInBytes.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.sizeInBytes)
      .optionallyWith(endpointInfo.map(value => value.buildAwsValue()))(
        _.endpointInfo
      )
      .optionallyWith(
        trainingParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.trainingParameters)
      .optionallyWith(
        inputDataLocationS3.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.inputDataLocationS3)
      .optionallyWith(algorithm.map(value => value.unwrap))(_.algorithm)
      .optionallyWith(mlModelType.map(value => value.unwrap))(_.mlModelType)
      .optionallyWith(
        scoreThreshold.map(value =>
          ScoreThreshold.unwrap(value): java.lang.Float
        )
      )(_.scoreThreshold)
      .optionallyWith(
        scoreThresholdLastUpdatedAt.map(value =>
          EpochTime.unwrap(value): Instant
        )
      )(_.scoreThresholdLastUpdatedAt)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        computeTime.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.computeTime)
      .optionallyWith(
        finishedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.finishedAt)
      .optionallyWith(startedAt.map(value => EpochTime.unwrap(value): Instant))(
        _.startedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.MLModel.ReadOnly =
    zio.aws.machinelearning.model.MLModel.wrap(buildAwsValue())
}
object MLModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.MLModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.MLModel =
      zio.aws.machinelearning.model.MLModel(
        mlModelId.map(value => value),
        trainingDataSourceId.map(value => value),
        createdByIamUser.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        status.map(value => value),
        sizeInBytes.map(value => value),
        endpointInfo.map(value => value.asEditable),
        trainingParameters.map(value => value),
        inputDataLocationS3.map(value => value),
        algorithm.map(value => value),
        mlModelType.map(value => value),
        scoreThreshold.map(value => value),
        scoreThresholdLastUpdatedAt.map(value => value),
        message.map(value => value),
        computeTime.map(value => value),
        finishedAt.map(value => value),
        startedAt.map(value => value)
      )
    def mlModelId: Optional[EntityId]
    def trainingDataSourceId: Optional[EntityId]
    def createdByIamUser: Optional[AwsUserArn]
    def createdAt: Optional[EpochTime]
    def lastUpdatedAt: Optional[EpochTime]
    def name: Optional[MLModelName]
    def status: Optional[zio.aws.machinelearning.model.EntityStatus]
    def sizeInBytes: Optional[LongType]
    def endpointInfo
        : Optional[zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly]
    def trainingParameters: Optional[Map[StringType, StringType]]
    def inputDataLocationS3: Optional[S3Url]
    def algorithm: Optional[zio.aws.machinelearning.model.Algorithm]
    def mlModelType: Optional[zio.aws.machinelearning.model.MLModelType]
    def scoreThreshold: Optional[ScoreThreshold]
    def scoreThresholdLastUpdatedAt: Optional[EpochTime]
    def message: Optional[Message]
    def computeTime: Optional[LongType]
    def finishedAt: Optional[EpochTime]
    def startedAt: Optional[EpochTime]
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
    def getTrainingDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("trainingDataSourceId", trainingDataSourceId)
    def getCreatedByIamUser: ZIO[Any, AwsError, AwsUserArn] =
      AwsError.unwrapOptionField("createdByIamUser", createdByIamUser)
    def getCreatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, MLModelName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.EntityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSizeInBytes: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
    def getEndpointInfo: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly
    ] = AwsError.unwrapOptionField("endpointInfo", endpointInfo)
    def getTrainingParameters: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("trainingParameters", trainingParameters)
    def getInputDataLocationS3: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("inputDataLocationS3", inputDataLocationS3)
    def getAlgorithm
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.Algorithm] =
      AwsError.unwrapOptionField("algorithm", algorithm)
    def getMlModelType
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.MLModelType] =
      AwsError.unwrapOptionField("mlModelType", mlModelType)
    def getScoreThreshold: ZIO[Any, AwsError, ScoreThreshold] =
      AwsError.unwrapOptionField("scoreThreshold", scoreThreshold)
    def getScoreThresholdLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField(
        "scoreThresholdLastUpdatedAt",
        scoreThresholdLastUpdatedAt
      )
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getComputeTime: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("computeTime", computeTime)
    def getFinishedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("finishedAt", finishedAt)
    def getStartedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.MLModel
  ) extends zio.aws.machinelearning.model.MLModel.ReadOnly {
    override val mlModelId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val trainingDataSourceId: Optional[EntityId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingDataSourceId())
        .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val createdByIamUser: Optional[AwsUserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.createdByIamUser())
      .map(value => zio.aws.machinelearning.model.primitives.AwsUserArn(value))
    override val createdAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val lastUpdatedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val name: Optional[MLModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.machinelearning.model.primitives.MLModelName(value))
    override val status: Optional[zio.aws.machinelearning.model.EntityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.machinelearning.model.EntityStatus.wrap(value))
    override val sizeInBytes: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInBytes())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val endpointInfo: Optional[
      zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointInfo())
      .map(value =>
        zio.aws.machinelearning.model.RealtimeEndpointInfo.wrap(value)
      )
    override val trainingParameters: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
    override val inputDataLocationS3: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDataLocationS3())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val algorithm: Optional[zio.aws.machinelearning.model.Algorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.algorithm())
        .map(value => zio.aws.machinelearning.model.Algorithm.wrap(value))
    override val mlModelType
        : Optional[zio.aws.machinelearning.model.MLModelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mlModelType())
        .map(value => zio.aws.machinelearning.model.MLModelType.wrap(value))
    override val scoreThreshold: Optional[ScoreThreshold] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scoreThreshold())
        .map(value =>
          zio.aws.machinelearning.model.primitives.ScoreThreshold(value)
        )
    override val scoreThresholdLastUpdatedAt: Optional[EpochTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scoreThresholdLastUpdatedAt())
        .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.machinelearning.model.primitives.Message(value))
    override val computeTime: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.computeTime())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val finishedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.finishedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val startedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.MLModel
  ): zio.aws.machinelearning.model.MLModel.ReadOnly = new Wrapper(impl)
}
