package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class DeleteMlModelRequest(mlModelId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteMlModelRequest = {
    import DeleteMlModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteMlModelRequest
      .builder()
      .mlModelId(EntityId.unwrap(mlModelId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.DeleteMlModelRequest.ReadOnly =
    zio.aws.machinelearning.model.DeleteMlModelRequest.wrap(buildAwsValue())
}
object DeleteMlModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteMlModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DeleteMlModelRequest =
      zio.aws.machinelearning.model.DeleteMlModelRequest(mlModelId)
    def mlModelId: EntityId
    def getMlModelId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(mlModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteMlModelRequest
  ) extends zio.aws.machinelearning.model.DeleteMlModelRequest.ReadOnly {
    override val mlModelId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.mlModelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteMlModelRequest
  ): zio.aws.machinelearning.model.DeleteMlModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
