package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class DescribeTagsRequest(
    resourceId: EntityId,
    resourceType: zio.aws.machinelearning.model.TaggableResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DescribeTagsRequest = {
    import DescribeTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DescribeTagsRequest
      .builder()
      .resourceId(EntityId.unwrap(resourceId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.DescribeTagsRequest.ReadOnly =
    zio.aws.machinelearning.model.DescribeTagsRequest.wrap(buildAwsValue())
}
object DescribeTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DescribeTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DescribeTagsRequest =
      zio.aws.machinelearning.model
        .DescribeTagsRequest(resourceId, resourceType)
    def resourceId: EntityId
    def resourceType: zio.aws.machinelearning.model.TaggableResourceType
    def getResourceId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(resourceId)
    def getResourceType: ZIO[
      Any,
      Nothing,
      zio.aws.machinelearning.model.TaggableResourceType
    ] = ZIO.succeed(resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeTagsRequest
  ) extends zio.aws.machinelearning.model.DescribeTagsRequest.ReadOnly {
    override val resourceId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.resourceId())
    override val resourceType
        : zio.aws.machinelearning.model.TaggableResourceType =
      zio.aws.machinelearning.model.TaggableResourceType
        .wrap(impl.resourceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeTagsRequest
  ): zio.aws.machinelearning.model.DescribeTagsRequest.ReadOnly = new Wrapper(
    impl
  )
}
