package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class DeleteEvaluationRequest(evaluationId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationRequest = {
    import DeleteEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationRequest
      .builder()
      .evaluationId(EntityId.unwrap(evaluationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DeleteEvaluationRequest.ReadOnly =
    zio.aws.machinelearning.model.DeleteEvaluationRequest.wrap(buildAwsValue())
}
object DeleteEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DeleteEvaluationRequest =
      zio.aws.machinelearning.model.DeleteEvaluationRequest(evaluationId)
    def evaluationId: EntityId
    def getEvaluationId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(evaluationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationRequest
  ) extends zio.aws.machinelearning.model.DeleteEvaluationRequest.ReadOnly {
    override val evaluationId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.evaluationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationRequest
  ): zio.aws.machinelearning.model.DeleteEvaluationRequest.ReadOnly =
    new Wrapper(impl)
}
