package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBatchPredictionResponse(
    batchPredictionId: Optional[EntityId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionResponse = {
    import DeleteBatchPredictionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionResponse
      .builder()
      .optionallyWith(
        batchPredictionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.batchPredictionId)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DeleteBatchPredictionResponse.ReadOnly =
    zio.aws.machinelearning.model.DeleteBatchPredictionResponse
      .wrap(buildAwsValue())
}
object DeleteBatchPredictionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.DeleteBatchPredictionResponse =
      zio.aws.machinelearning.model
        .DeleteBatchPredictionResponse(batchPredictionId.map(value => value))
    def batchPredictionId: Optional[EntityId]
    def getBatchPredictionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("batchPredictionId", batchPredictionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionResponse
  ) extends zio.aws.machinelearning.model.DeleteBatchPredictionResponse.ReadOnly {
    override val batchPredictionId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.batchPredictionId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionResponse
  ): zio.aws.machinelearning.model.DeleteBatchPredictionResponse.ReadOnly =
    new Wrapper(impl)
}
