package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddTagsResponse(
    resourceId: Optional[EntityId] = Optional.Absent,
    resourceType: Optional[zio.aws.machinelearning.model.TaggableResourceType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.AddTagsResponse = {
    import AddTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.AddTagsResponse
      .builder()
      .optionallyWith(
        resourceId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.AddTagsResponse.ReadOnly =
    zio.aws.machinelearning.model.AddTagsResponse.wrap(buildAwsValue())
}
object AddTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.AddTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.AddTagsResponse =
      zio.aws.machinelearning.model.AddTagsResponse(
        resourceId.map(value => value),
        resourceType.map(value => value)
      )
    def resourceId: Optional[EntityId]
    def resourceType
        : Optional[zio.aws.machinelearning.model.TaggableResourceType]
    def getResourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.TaggableResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.AddTagsResponse
  ) extends zio.aws.machinelearning.model.AddTagsResponse.ReadOnly {
    override val resourceId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val resourceType
        : Optional[zio.aws.machinelearning.model.TaggableResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.machinelearning.model.TaggableResourceType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.AddTagsResponse
  ): zio.aws.machinelearning.model.AddTagsResponse.ReadOnly = new Wrapper(impl)
}
