package zio.aws.machinelearning.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.machinelearning.model.primitives.{
  Message,
  S3Url,
  EpochTime,
  EntityId,
  LongType,
  PresignedS3Url,
  EntityName,
  AwsUserArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetBatchPredictionResponse(
    batchPredictionId: Optional[EntityId] = Optional.Absent,
    mlModelId: Optional[EntityId] = Optional.Absent,
    batchPredictionDataSourceId: Optional[EntityId] = Optional.Absent,
    inputDataLocationS3: Optional[S3Url] = Optional.Absent,
    createdByIamUser: Optional[AwsUserArn] = Optional.Absent,
    createdAt: Optional[EpochTime] = Optional.Absent,
    lastUpdatedAt: Optional[EpochTime] = Optional.Absent,
    name: Optional[EntityName] = Optional.Absent,
    status: Optional[zio.aws.machinelearning.model.EntityStatus] =
      Optional.Absent,
    outputUri: Optional[S3Url] = Optional.Absent,
    logUri: Optional[PresignedS3Url] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    computeTime: Optional[LongType] = Optional.Absent,
    finishedAt: Optional[EpochTime] = Optional.Absent,
    startedAt: Optional[EpochTime] = Optional.Absent,
    totalRecordCount: Optional[LongType] = Optional.Absent,
    invalidRecordCount: Optional[LongType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse = {
    import GetBatchPredictionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse
      .builder()
      .optionallyWith(
        batchPredictionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.batchPredictionId)
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .optionallyWith(
        batchPredictionDataSourceId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.batchPredictionDataSourceId)
      .optionallyWith(
        inputDataLocationS3.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.inputDataLocationS3)
      .optionallyWith(
        createdByIamUser.map(value =>
          AwsUserArn.unwrap(value): java.lang.String
        )
      )(_.createdByIamUser)
      .optionallyWith(createdAt.map(value => EpochTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        outputUri.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.outputUri)
      .optionallyWith(
        logUri.map(value => PresignedS3Url.unwrap(value): java.lang.String)
      )(_.logUri)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        computeTime.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.computeTime)
      .optionallyWith(
        finishedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.finishedAt)
      .optionallyWith(startedAt.map(value => EpochTime.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        totalRecordCount.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.totalRecordCount)
      .optionallyWith(
        invalidRecordCount.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.invalidRecordCount)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly =
    zio.aws.machinelearning.model.GetBatchPredictionResponse
      .wrap(buildAwsValue())
}
object GetBatchPredictionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetBatchPredictionResponse =
      zio.aws.machinelearning.model.GetBatchPredictionResponse(
        batchPredictionId.map(value => value),
        mlModelId.map(value => value),
        batchPredictionDataSourceId.map(value => value),
        inputDataLocationS3.map(value => value),
        createdByIamUser.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        status.map(value => value),
        outputUri.map(value => value),
        logUri.map(value => value),
        message.map(value => value),
        computeTime.map(value => value),
        finishedAt.map(value => value),
        startedAt.map(value => value),
        totalRecordCount.map(value => value),
        invalidRecordCount.map(value => value)
      )
    def batchPredictionId: Optional[EntityId]
    def mlModelId: Optional[EntityId]
    def batchPredictionDataSourceId: Optional[EntityId]
    def inputDataLocationS3: Optional[S3Url]
    def createdByIamUser: Optional[AwsUserArn]
    def createdAt: Optional[EpochTime]
    def lastUpdatedAt: Optional[EpochTime]
    def name: Optional[EntityName]
    def status: Optional[zio.aws.machinelearning.model.EntityStatus]
    def outputUri: Optional[S3Url]
    def logUri: Optional[PresignedS3Url]
    def message: Optional[Message]
    def computeTime: Optional[LongType]
    def finishedAt: Optional[EpochTime]
    def startedAt: Optional[EpochTime]
    def totalRecordCount: Optional[LongType]
    def invalidRecordCount: Optional[LongType]
    def getBatchPredictionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("batchPredictionId", batchPredictionId)
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
    def getBatchPredictionDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField(
        "batchPredictionDataSourceId",
        batchPredictionDataSourceId
      )
    def getInputDataLocationS3: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("inputDataLocationS3", inputDataLocationS3)
    def getCreatedByIamUser: ZIO[Any, AwsError, AwsUserArn] =
      AwsError.unwrapOptionField("createdByIamUser", createdByIamUser)
    def getCreatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.EntityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOutputUri: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("outputUri", outputUri)
    def getLogUri: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getComputeTime: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("computeTime", computeTime)
    def getFinishedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("finishedAt", finishedAt)
    def getStartedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getTotalRecordCount: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("totalRecordCount", totalRecordCount)
    def getInvalidRecordCount: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("invalidRecordCount", invalidRecordCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse
  ) extends zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly {
    override val batchPredictionId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.batchPredictionId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val mlModelId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val batchPredictionDataSourceId: Optional[EntityId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchPredictionDataSourceId())
        .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val inputDataLocationS3: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDataLocationS3())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val createdByIamUser: Optional[AwsUserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.createdByIamUser())
      .map(value => zio.aws.machinelearning.model.primitives.AwsUserArn(value))
    override val createdAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val lastUpdatedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val name: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val status: Optional[zio.aws.machinelearning.model.EntityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.machinelearning.model.EntityStatus.wrap(value))
    override val outputUri: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.outputUri())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val logUri: Optional[PresignedS3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.logUri())
      .map(value =>
        zio.aws.machinelearning.model.primitives.PresignedS3Url(value)
      )
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.machinelearning.model.primitives.Message(value))
    override val computeTime: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.computeTime())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val finishedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.finishedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val startedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val totalRecordCount: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.totalRecordCount())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val invalidRecordCount: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.invalidRecordCount())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse
  ): zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly =
    new Wrapper(impl)
}
