package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.StringType
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEvaluationsResponse(
    results: Optional[Iterable[zio.aws.machinelearning.model.Evaluation]] =
      Optional.Absent,
    nextToken: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse = {
    import DescribeEvaluationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DescribeEvaluationsResponse.ReadOnly =
    zio.aws.machinelearning.model.DescribeEvaluationsResponse
      .wrap(buildAwsValue())
}
object DescribeEvaluationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DescribeEvaluationsResponse =
      zio.aws.machinelearning.model.DescribeEvaluationsResponse(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def results
        : Optional[List[zio.aws.machinelearning.model.Evaluation.ReadOnly]]
    def nextToken: Optional[StringType]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.machinelearning.model.Evaluation.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
    def getNextToken: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse
  ) extends zio.aws.machinelearning.model.DescribeEvaluationsResponse.ReadOnly {
    override val results
        : Optional[List[zio.aws.machinelearning.model.Evaluation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.results())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.machinelearning.model.Evaluation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse
  ): zio.aws.machinelearning.model.DescribeEvaluationsResponse.ReadOnly =
    new Wrapper(impl)
}
