package zio.aws.machinelearning.model
import scala.jdk.CollectionConverters._
sealed trait DataSourceFilterVariable {
  def unwrap: software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable
}
object DataSourceFilterVariable {
  def wrap(
      value: software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable
  ): zio.aws.machinelearning.model.DataSourceFilterVariable = value match {
    case software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.CREATED_AT =>
      val r = CreatedAt
      r
    case software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.LAST_UPDATED_AT =>
      val r = LastUpdatedAt
      r
    case software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.STATUS =>
      val r = Status
      r
    case software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.DATA_LOCATION_S3 =>
      val r = DataLocationS3
      r
    case software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.IAM_USER =>
      val r = IAMUser
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.machinelearning.model.DataSourceFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.UNKNOWN_TO_SDK_VERSION
  }
  case object CreatedAt
      extends zio.aws.machinelearning.model.DataSourceFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.CREATED_AT
  }
  case object LastUpdatedAt
      extends zio.aws.machinelearning.model.DataSourceFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.LAST_UPDATED_AT
  }
  case object Status
      extends zio.aws.machinelearning.model.DataSourceFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.STATUS
  }
  case object Name
      extends zio.aws.machinelearning.model.DataSourceFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.NAME
  }
  case object DataLocationS3
      extends zio.aws.machinelearning.model.DataSourceFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.DATA_LOCATION_S3
  }
  case object IAMUser
      extends zio.aws.machinelearning.model.DataSourceFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.DataSourceFilterVariable.IAM_USER
  }
}
