package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEvaluationResponse(
    evaluationId: Optional[EntityId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateEvaluationResponse = {
    import CreateEvaluationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateEvaluationResponse
      .builder()
      .optionallyWith(
        evaluationId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.evaluationId)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.CreateEvaluationResponse.ReadOnly =
    zio.aws.machinelearning.model.CreateEvaluationResponse.wrap(buildAwsValue())
}
object CreateEvaluationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateEvaluationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.CreateEvaluationResponse =
      zio.aws.machinelearning.model
        .CreateEvaluationResponse(evaluationId.map(value => value))
    def evaluationId: Optional[EntityId]
    def getEvaluationId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("evaluationId", evaluationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateEvaluationResponse
  ) extends zio.aws.machinelearning.model.CreateEvaluationResponse.ReadOnly {
    override val evaluationId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateEvaluationResponse
  ): zio.aws.machinelearning.model.CreateEvaluationResponse.ReadOnly =
    new Wrapper(impl)
}
