package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.{EntityName, EntityId}
import scala.jdk.CollectionConverters._
final case class UpdateEvaluationRequest(
    evaluationId: EntityId,
    evaluationName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationRequest = {
    import UpdateEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationRequest
      .builder()
      .evaluationId(EntityId.unwrap(evaluationId): java.lang.String)
      .evaluationName(EntityName.unwrap(evaluationName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.UpdateEvaluationRequest.ReadOnly =
    zio.aws.machinelearning.model.UpdateEvaluationRequest.wrap(buildAwsValue())
}
object UpdateEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.UpdateEvaluationRequest =
      zio.aws.machinelearning.model
        .UpdateEvaluationRequest(evaluationId, evaluationName)
    def evaluationId: EntityId
    def evaluationName: EntityName
    def getEvaluationId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(evaluationId)
    def getEvaluationName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(evaluationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationRequest
  ) extends zio.aws.machinelearning.model.UpdateEvaluationRequest.ReadOnly {
    override val evaluationId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.evaluationId())
    override val evaluationName: EntityName =
      zio.aws.machinelearning.model.primitives.EntityName(impl.evaluationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationRequest
  ): zio.aws.machinelearning.model.UpdateEvaluationRequest.ReadOnly =
    new Wrapper(impl)
}
