package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{Verbose, EntityId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMlModelRequest(
    mlModelId: EntityId,
    verbose: Optional[Verbose] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetMlModelRequest = {
    import GetMlModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetMlModelRequest
      .builder()
      .mlModelId(EntityId.unwrap(mlModelId): java.lang.String)
      .optionallyWith(
        verbose.map(value => Verbose.unwrap(value): java.lang.Boolean)
      )(_.verbose)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.GetMlModelRequest.ReadOnly =
    zio.aws.machinelearning.model.GetMlModelRequest.wrap(buildAwsValue())
}
object GetMlModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetMlModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetMlModelRequest =
      zio.aws.machinelearning.model
        .GetMlModelRequest(mlModelId, verbose.map(value => value))
    def mlModelId: EntityId
    def verbose: Optional[Verbose]
    def getMlModelId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(mlModelId)
    def getVerbose: ZIO[Any, AwsError, Verbose] =
      AwsError.unwrapOptionField("verbose", verbose)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetMlModelRequest
  ) extends zio.aws.machinelearning.model.GetMlModelRequest.ReadOnly {
    override val mlModelId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.mlModelId())
    override val verbose: Optional[Verbose] = zio.aws.core.internal
      .optionalFromNullable(impl.verbose())
      .map(value => zio.aws.machinelearning.model.primitives.Verbose(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetMlModelRequest
  ): zio.aws.machinelearning.model.GetMlModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
