package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  DataSchema,
  Message,
  DataRearrangement,
  S3Url,
  RoleARN,
  EpochTime,
  EntityId,
  LongType,
  ComputeStatistics,
  PresignedS3Url,
  EntityName,
  AwsUserArn
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetDataSourceResponse(
    dataSourceId: Option[EntityId] = None,
    dataLocationS3: Option[S3Url] = None,
    dataRearrangement: Option[DataRearrangement] = None,
    createdByIamUser: Option[AwsUserArn] = None,
    createdAt: Option[EpochTime] = None,
    lastUpdatedAt: Option[EpochTime] = None,
    dataSizeInBytes: Option[LongType] = None,
    numberOfFiles: Option[LongType] = None,
    name: Option[EntityName] = None,
    status: Option[zio.aws.machinelearning.model.EntityStatus] = None,
    logUri: Option[PresignedS3Url] = None,
    message: Option[Message] = None,
    redshiftMetadata: Option[zio.aws.machinelearning.model.RedshiftMetadata] =
      None,
    rdsMetadata: Option[zio.aws.machinelearning.model.RDSMetadata] = None,
    roleARN: Option[RoleARN] = None,
    computeStatistics: Option[ComputeStatistics] = None,
    computeTime: Option[LongType] = None,
    finishedAt: Option[EpochTime] = None,
    startedAt: Option[EpochTime] = None,
    dataSourceSchema: Option[DataSchema] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse = {
    import GetDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse
      .builder()
      .optionallyWith(
        dataSourceId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .optionallyWith(
        dataLocationS3.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.dataLocationS3)
      .optionallyWith(
        dataRearrangement.map(value =>
          DataRearrangement.unwrap(value): java.lang.String
        )
      )(_.dataRearrangement)
      .optionallyWith(
        createdByIamUser.map(value =>
          AwsUserArn.unwrap(value): java.lang.String
        )
      )(_.createdByIamUser)
      .optionallyWith(createdAt.map(value => EpochTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        dataSizeInBytes.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.dataSizeInBytes)
      .optionallyWith(
        numberOfFiles.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.numberOfFiles)
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        logUri.map(value => PresignedS3Url.unwrap(value): java.lang.String)
      )(_.logUri)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(redshiftMetadata.map(value => value.buildAwsValue()))(
        _.redshiftMetadata
      )
      .optionallyWith(rdsMetadata.map(value => value.buildAwsValue()))(
        _.rdsMetadata
      )
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        computeStatistics.map(value =>
          ComputeStatistics.unwrap(value): java.lang.Boolean
        )
      )(_.computeStatistics)
      .optionallyWith(
        computeTime.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.computeTime)
      .optionallyWith(
        finishedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.finishedAt)
      .optionallyWith(startedAt.map(value => EpochTime.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        dataSourceSchema.map(value =>
          DataSchema.unwrap(value): java.lang.String
        )
      )(_.dataSourceSchema)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly =
    zio.aws.machinelearning.model.GetDataSourceResponse.wrap(buildAwsValue())
}
object GetDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetDataSourceResponse =
      zio.aws.machinelearning.model.GetDataSourceResponse(
        dataSourceId.map(value => value),
        dataLocationS3.map(value => value),
        dataRearrangement.map(value => value),
        createdByIamUser.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        dataSizeInBytes.map(value => value),
        numberOfFiles.map(value => value),
        name.map(value => value),
        status.map(value => value),
        logUri.map(value => value),
        message.map(value => value),
        redshiftMetadata.map(value => value.asEditable),
        rdsMetadata.map(value => value.asEditable),
        roleARN.map(value => value),
        computeStatistics.map(value => value),
        computeTime.map(value => value),
        finishedAt.map(value => value),
        startedAt.map(value => value),
        dataSourceSchema.map(value => value)
      )
    def dataSourceId: Option[EntityId]
    def dataLocationS3: Option[S3Url]
    def dataRearrangement: Option[DataRearrangement]
    def createdByIamUser: Option[AwsUserArn]
    def createdAt: Option[EpochTime]
    def lastUpdatedAt: Option[EpochTime]
    def dataSizeInBytes: Option[LongType]
    def numberOfFiles: Option[LongType]
    def name: Option[EntityName]
    def status: Option[zio.aws.machinelearning.model.EntityStatus]
    def logUri: Option[PresignedS3Url]
    def message: Option[Message]
    def redshiftMetadata
        : Option[zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly]
    def rdsMetadata: Option[zio.aws.machinelearning.model.RDSMetadata.ReadOnly]
    def roleARN: Option[RoleARN]
    def computeStatistics: Option[ComputeStatistics]
    def computeTime: Option[LongType]
    def finishedAt: Option[EpochTime]
    def startedAt: Option[EpochTime]
    def dataSourceSchema: Option[DataSchema]
    def getDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
    def getDataLocationS3: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("dataLocationS3", dataLocationS3)
    def getDataRearrangement: ZIO[Any, AwsError, DataRearrangement] =
      AwsError.unwrapOptionField("dataRearrangement", dataRearrangement)
    def getCreatedByIamUser: ZIO[Any, AwsError, AwsUserArn] =
      AwsError.unwrapOptionField("createdByIamUser", createdByIamUser)
    def getCreatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getDataSizeInBytes: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("dataSizeInBytes", dataSizeInBytes)
    def getNumberOfFiles: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("numberOfFiles", numberOfFiles)
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.EntityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLogUri: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getRedshiftMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("redshiftMetadata", redshiftMetadata)
    def getRdsMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RDSMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("rdsMetadata", rdsMetadata)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getComputeStatistics: ZIO[Any, AwsError, ComputeStatistics] =
      AwsError.unwrapOptionField("computeStatistics", computeStatistics)
    def getComputeTime: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("computeTime", computeTime)
    def getFinishedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("finishedAt", finishedAt)
    def getStartedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getDataSourceSchema: ZIO[Any, AwsError, DataSchema] =
      AwsError.unwrapOptionField("dataSourceSchema", dataSourceSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse
  ) extends zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly {
    override val dataSourceId: Option[EntityId] = scala
      .Option(impl.dataSourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val dataLocationS3: Option[S3Url] = scala
      .Option(impl.dataLocationS3())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val dataRearrangement: Option[DataRearrangement] = scala
      .Option(impl.dataRearrangement())
      .map(value =>
        zio.aws.machinelearning.model.primitives.DataRearrangement(value)
      )
    override val createdByIamUser: Option[AwsUserArn] = scala
      .Option(impl.createdByIamUser())
      .map(value => zio.aws.machinelearning.model.primitives.AwsUserArn(value))
    override val createdAt: Option[EpochTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val lastUpdatedAt: Option[EpochTime] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val dataSizeInBytes: Option[LongType] = scala
      .Option(impl.dataSizeInBytes())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val numberOfFiles: Option[LongType] = scala
      .Option(impl.numberOfFiles())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val name: Option[EntityName] = scala
      .Option(impl.name())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val status: Option[zio.aws.machinelearning.model.EntityStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.machinelearning.model.EntityStatus.wrap(value))
    override val logUri: Option[PresignedS3Url] = scala
      .Option(impl.logUri())
      .map(value =>
        zio.aws.machinelearning.model.primitives.PresignedS3Url(value)
      )
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.machinelearning.model.primitives.Message(value))
    override val redshiftMetadata
        : Option[zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly] =
      scala
        .Option(impl.redshiftMetadata())
        .map(value =>
          zio.aws.machinelearning.model.RedshiftMetadata.wrap(value)
        )
    override val rdsMetadata
        : Option[zio.aws.machinelearning.model.RDSMetadata.ReadOnly] = scala
      .Option(impl.rdsMetadata())
      .map(value => zio.aws.machinelearning.model.RDSMetadata.wrap(value))
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.machinelearning.model.primitives.RoleARN(value))
    override val computeStatistics: Option[ComputeStatistics] = scala
      .Option(impl.computeStatistics())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComputeStatistics(value)
      )
    override val computeTime: Option[LongType] = scala
      .Option(impl.computeTime())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val finishedAt: Option[EpochTime] = scala
      .Option(impl.finishedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val startedAt: Option[EpochTime] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val dataSourceSchema: Option[DataSchema] = scala
      .Option(impl.dataSourceSchema())
      .map(value => zio.aws.machinelearning.model.primitives.DataSchema(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse
  ): zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
