package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class DeleteRealtimeEndpointResponse(
    mlModelId: Option[EntityId] = None,
    realtimeEndpointInfo: Option[
      zio.aws.machinelearning.model.RealtimeEndpointInfo
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointResponse = {
    import DeleteRealtimeEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointResponse
      .builder()
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .optionallyWith(realtimeEndpointInfo.map(value => value.buildAwsValue()))(
        _.realtimeEndpointInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse.ReadOnly =
    zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse
      .wrap(buildAwsValue())
}
object DeleteRealtimeEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse =
      zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse(
        mlModelId.map(value => value),
        realtimeEndpointInfo.map(value => value.asEditable)
      )
    def mlModelId: Option[EntityId]
    def realtimeEndpointInfo
        : Option[zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly]
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
    def getRealtimeEndpointInfo: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly
    ] = AwsError.unwrapOptionField("realtimeEndpointInfo", realtimeEndpointInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointResponse
  ) extends zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse.ReadOnly {
    override val mlModelId: Option[EntityId] = scala
      .Option(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val realtimeEndpointInfo
        : Option[zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly] =
      scala
        .Option(impl.realtimeEndpointInfo())
        .map(value =>
          zio.aws.machinelearning.model.RealtimeEndpointInfo.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointResponse
  ): zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
