package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  DataSchema,
  DataRearrangement,
  S3Url
}
import scala.jdk.CollectionConverters._
final case class S3DataSpec(
    dataLocationS3: S3Url,
    dataRearrangement: Option[DataRearrangement] = None,
    dataSchema: Option[DataSchema] = None,
    dataSchemaLocationS3: Option[S3Url] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.S3DataSpec = {
    import S3DataSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.S3DataSpec
      .builder()
      .dataLocationS3(S3Url.unwrap(dataLocationS3): java.lang.String)
      .optionallyWith(
        dataRearrangement.map(value =>
          DataRearrangement.unwrap(value): java.lang.String
        )
      )(_.dataRearrangement)
      .optionallyWith(
        dataSchema.map(value => DataSchema.unwrap(value): java.lang.String)
      )(_.dataSchema)
      .optionallyWith(
        dataSchemaLocationS3.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.dataSchemaLocationS3)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.S3DataSpec.ReadOnly =
    zio.aws.machinelearning.model.S3DataSpec.wrap(buildAwsValue())
}
object S3DataSpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.S3DataSpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.S3DataSpec =
      zio.aws.machinelearning.model.S3DataSpec(
        dataLocationS3,
        dataRearrangement.map(value => value),
        dataSchema.map(value => value),
        dataSchemaLocationS3.map(value => value)
      )
    def dataLocationS3: S3Url
    def dataRearrangement: Option[DataRearrangement]
    def dataSchema: Option[DataSchema]
    def dataSchemaLocationS3: Option[S3Url]
    def getDataLocationS3: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(dataLocationS3)
    def getDataRearrangement: ZIO[Any, AwsError, DataRearrangement] =
      AwsError.unwrapOptionField("dataRearrangement", dataRearrangement)
    def getDataSchema: ZIO[Any, AwsError, DataSchema] =
      AwsError.unwrapOptionField("dataSchema", dataSchema)
    def getDataSchemaLocationS3: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("dataSchemaLocationS3", dataSchemaLocationS3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.S3DataSpec
  ) extends zio.aws.machinelearning.model.S3DataSpec.ReadOnly {
    override val dataLocationS3: S3Url =
      zio.aws.machinelearning.model.primitives.S3Url(impl.dataLocationS3())
    override val dataRearrangement: Option[DataRearrangement] = scala
      .Option(impl.dataRearrangement())
      .map(value =>
        zio.aws.machinelearning.model.primitives.DataRearrangement(value)
      )
    override val dataSchema: Option[DataSchema] = scala
      .Option(impl.dataSchema())
      .map(value => zio.aws.machinelearning.model.primitives.DataSchema(value))
    override val dataSchemaLocationS3: Option[S3Url] = scala
      .Option(impl.dataSchemaLocationS3())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.S3DataSpec
  ): zio.aws.machinelearning.model.S3DataSpec.ReadOnly = new Wrapper(impl)
}
