package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  RedshiftSelectSqlQuery,
  RedshiftDatabaseUsername
}
import scala.jdk.CollectionConverters._
final case class RedshiftMetadata(
    redshiftDatabase: Option[zio.aws.machinelearning.model.RedshiftDatabase] =
      None,
    databaseUserName: Option[RedshiftDatabaseUsername] = None,
    selectSqlQuery: Option[RedshiftSelectSqlQuery] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata = {
    import RedshiftMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata
      .builder()
      .optionallyWith(redshiftDatabase.map(value => value.buildAwsValue()))(
        _.redshiftDatabase
      )
      .optionallyWith(
        databaseUserName.map(value =>
          RedshiftDatabaseUsername.unwrap(value): java.lang.String
        )
      )(_.databaseUserName)
      .optionallyWith(
        selectSqlQuery.map(value =>
          RedshiftSelectSqlQuery.unwrap(value): java.lang.String
        )
      )(_.selectSqlQuery)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly =
    zio.aws.machinelearning.model.RedshiftMetadata.wrap(buildAwsValue())
}
object RedshiftMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RedshiftMetadata =
      zio.aws.machinelearning.model.RedshiftMetadata(
        redshiftDatabase.map(value => value.asEditable),
        databaseUserName.map(value => value),
        selectSqlQuery.map(value => value)
      )
    def redshiftDatabase
        : Option[zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly]
    def databaseUserName: Option[RedshiftDatabaseUsername]
    def selectSqlQuery: Option[RedshiftSelectSqlQuery]
    def getRedshiftDatabase: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly
    ] = AwsError.unwrapOptionField("redshiftDatabase", redshiftDatabase)
    def getDatabaseUserName: ZIO[Any, AwsError, RedshiftDatabaseUsername] =
      AwsError.unwrapOptionField("databaseUserName", databaseUserName)
    def getSelectSqlQuery: ZIO[Any, AwsError, RedshiftSelectSqlQuery] =
      AwsError.unwrapOptionField("selectSqlQuery", selectSqlQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata
  ) extends zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly {
    override val redshiftDatabase
        : Option[zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly] =
      scala
        .Option(impl.redshiftDatabase())
        .map(value =>
          zio.aws.machinelearning.model.RedshiftDatabase.wrap(value)
        )
    override val databaseUserName: Option[RedshiftDatabaseUsername] = scala
      .Option(impl.databaseUserName())
      .map(value =>
        zio.aws.machinelearning.model.primitives.RedshiftDatabaseUsername(value)
      )
    override val selectSqlQuery: Option[RedshiftSelectSqlQuery] = scala
      .Option(impl.selectSqlQuery())
      .map(value =>
        zio.aws.machinelearning.model.primitives.RedshiftSelectSqlQuery(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata
  ): zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly = new Wrapper(impl)
}
