package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class AddTagsRequest(
    tags: Iterable[zio.aws.machinelearning.model.Tag],
    resourceId: EntityId,
    resourceType: zio.aws.machinelearning.model.TaggableResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.AddTagsRequest = {
    import AddTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.AddTagsRequest
      .builder()
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .resourceId(EntityId.unwrap(resourceId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.AddTagsRequest.ReadOnly =
    zio.aws.machinelearning.model.AddTagsRequest.wrap(buildAwsValue())
}
object AddTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.AddTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.AddTagsRequest =
      zio.aws.machinelearning.model.AddTagsRequest(
        tags.map { item =>
          item.asEditable
        },
        resourceId,
        resourceType
      )
    def tags: List[zio.aws.machinelearning.model.Tag.ReadOnly]
    def resourceId: EntityId
    def resourceType: zio.aws.machinelearning.model.TaggableResourceType
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.machinelearning.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
    def getResourceId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(resourceId)
    def getResourceType: ZIO[
      Any,
      Nothing,
      zio.aws.machinelearning.model.TaggableResourceType
    ] = ZIO.succeed(resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.AddTagsRequest
  ) extends zio.aws.machinelearning.model.AddTagsRequest.ReadOnly {
    override val tags: List[zio.aws.machinelearning.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.machinelearning.model.Tag.wrap(item)
      }
      .toList
    override val resourceId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.resourceId())
    override val resourceType
        : zio.aws.machinelearning.model.TaggableResourceType =
      zio.aws.machinelearning.model.TaggableResourceType
        .wrap(impl.resourceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.AddTagsRequest
  ): zio.aws.machinelearning.model.AddTagsRequest.ReadOnly = new Wrapper(impl)
}
