package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class DeleteEvaluationResponse(
    evaluationId: Option[EntityId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationResponse = {
    import DeleteEvaluationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationResponse
      .builder()
      .optionallyWith(
        evaluationId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.evaluationId)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DeleteEvaluationResponse.ReadOnly =
    zio.aws.machinelearning.model.DeleteEvaluationResponse.wrap(buildAwsValue())
}
object DeleteEvaluationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DeleteEvaluationResponse =
      zio.aws.machinelearning.model
        .DeleteEvaluationResponse(evaluationId.map(value => value))
    def evaluationId: Option[EntityId]
    def getEvaluationId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("evaluationId", evaluationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationResponse
  ) extends zio.aws.machinelearning.model.DeleteEvaluationResponse.ReadOnly {
    override val evaluationId: Option[EntityId] = scala
      .Option(impl.evaluationId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationResponse
  ): zio.aws.machinelearning.model.DeleteEvaluationResponse.ReadOnly =
    new Wrapper(impl)
}
