package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  Message,
  S3Url,
  EpochTime,
  EntityId,
  LongType,
  PresignedS3Url,
  EntityName,
  AwsUserArn
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetEvaluationResponse(
    evaluationId: Option[EntityId] = None,
    mlModelId: Option[EntityId] = None,
    evaluationDataSourceId: Option[EntityId] = None,
    inputDataLocationS3: Option[S3Url] = None,
    createdByIamUser: Option[AwsUserArn] = None,
    createdAt: Option[EpochTime] = None,
    lastUpdatedAt: Option[EpochTime] = None,
    name: Option[EntityName] = None,
    status: Option[zio.aws.machinelearning.model.EntityStatus] = None,
    performanceMetrics: Option[
      zio.aws.machinelearning.model.PerformanceMetrics
    ] = None,
    logUri: Option[PresignedS3Url] = None,
    message: Option[Message] = None,
    computeTime: Option[LongType] = None,
    finishedAt: Option[EpochTime] = None,
    startedAt: Option[EpochTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse = {
    import GetEvaluationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse
      .builder()
      .optionallyWith(
        evaluationId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.evaluationId)
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .optionallyWith(
        evaluationDataSourceId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.evaluationDataSourceId)
      .optionallyWith(
        inputDataLocationS3.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.inputDataLocationS3)
      .optionallyWith(
        createdByIamUser.map(value =>
          AwsUserArn.unwrap(value): java.lang.String
        )
      )(_.createdByIamUser)
      .optionallyWith(createdAt.map(value => EpochTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(performanceMetrics.map(value => value.buildAwsValue()))(
        _.performanceMetrics
      )
      .optionallyWith(
        logUri.map(value => PresignedS3Url.unwrap(value): java.lang.String)
      )(_.logUri)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        computeTime.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.computeTime)
      .optionallyWith(
        finishedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.finishedAt)
      .optionallyWith(startedAt.map(value => EpochTime.unwrap(value): Instant))(
        _.startedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly =
    zio.aws.machinelearning.model.GetEvaluationResponse.wrap(buildAwsValue())
}
object GetEvaluationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetEvaluationResponse =
      zio.aws.machinelearning.model.GetEvaluationResponse(
        evaluationId.map(value => value),
        mlModelId.map(value => value),
        evaluationDataSourceId.map(value => value),
        inputDataLocationS3.map(value => value),
        createdByIamUser.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        status.map(value => value),
        performanceMetrics.map(value => value.asEditable),
        logUri.map(value => value),
        message.map(value => value),
        computeTime.map(value => value),
        finishedAt.map(value => value),
        startedAt.map(value => value)
      )
    def evaluationId: Option[EntityId]
    def mlModelId: Option[EntityId]
    def evaluationDataSourceId: Option[EntityId]
    def inputDataLocationS3: Option[S3Url]
    def createdByIamUser: Option[AwsUserArn]
    def createdAt: Option[EpochTime]
    def lastUpdatedAt: Option[EpochTime]
    def name: Option[EntityName]
    def status: Option[zio.aws.machinelearning.model.EntityStatus]
    def performanceMetrics
        : Option[zio.aws.machinelearning.model.PerformanceMetrics.ReadOnly]
    def logUri: Option[PresignedS3Url]
    def message: Option[Message]
    def computeTime: Option[LongType]
    def finishedAt: Option[EpochTime]
    def startedAt: Option[EpochTime]
    def getEvaluationId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("evaluationId", evaluationId)
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
    def getEvaluationDataSourceId: ZIO[Any, AwsError, EntityId] = AwsError
      .unwrapOptionField("evaluationDataSourceId", evaluationDataSourceId)
    def getInputDataLocationS3: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("inputDataLocationS3", inputDataLocationS3)
    def getCreatedByIamUser: ZIO[Any, AwsError, AwsUserArn] =
      AwsError.unwrapOptionField("createdByIamUser", createdByIamUser)
    def getCreatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.EntityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getPerformanceMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.PerformanceMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("performanceMetrics", performanceMetrics)
    def getLogUri: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getComputeTime: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("computeTime", computeTime)
    def getFinishedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("finishedAt", finishedAt)
    def getStartedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse
  ) extends zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly {
    override val evaluationId: Option[EntityId] = scala
      .Option(impl.evaluationId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val mlModelId: Option[EntityId] = scala
      .Option(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val evaluationDataSourceId: Option[EntityId] = scala
      .Option(impl.evaluationDataSourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val inputDataLocationS3: Option[S3Url] = scala
      .Option(impl.inputDataLocationS3())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val createdByIamUser: Option[AwsUserArn] = scala
      .Option(impl.createdByIamUser())
      .map(value => zio.aws.machinelearning.model.primitives.AwsUserArn(value))
    override val createdAt: Option[EpochTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val lastUpdatedAt: Option[EpochTime] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val name: Option[EntityName] = scala
      .Option(impl.name())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val status: Option[zio.aws.machinelearning.model.EntityStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.machinelearning.model.EntityStatus.wrap(value))
    override val performanceMetrics
        : Option[zio.aws.machinelearning.model.PerformanceMetrics.ReadOnly] =
      scala
        .Option(impl.performanceMetrics())
        .map(value =>
          zio.aws.machinelearning.model.PerformanceMetrics.wrap(value)
        )
    override val logUri: Option[PresignedS3Url] = scala
      .Option(impl.logUri())
      .map(value =>
        zio.aws.machinelearning.model.primitives.PresignedS3Url(value)
      )
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.machinelearning.model.primitives.Message(value))
    override val computeTime: Option[LongType] = scala
      .Option(impl.computeTime())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val finishedAt: Option[EpochTime] = scala
      .Option(impl.finishedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val startedAt: Option[EpochTime] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse
  ): zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly = new Wrapper(
    impl
  )
}
