package zio.aws.machinelearning.model
import scala.jdk.CollectionConverters._
sealed trait Algorithm {
  def unwrap: software.amazon.awssdk.services.machinelearning.model.Algorithm
}
object Algorithm {
  def wrap(
      value: software.amazon.awssdk.services.machinelearning.model.Algorithm
  ): zio.aws.machinelearning.model.Algorithm = value match {
    case software.amazon.awssdk.services.machinelearning.model.Algorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.machinelearning.model.Algorithm.SGD =>
      val r = sgd
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.machinelearning.model.Algorithm {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.Algorithm =
      software.amazon.awssdk.services.machinelearning.model.Algorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object sgd extends zio.aws.machinelearning.model.Algorithm {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.Algorithm =
      software.amazon.awssdk.services.machinelearning.model.Algorithm.SGD
  }
}
