package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class DescribeBatchPredictionsResponse(
    results: Option[Iterable[zio.aws.machinelearning.model.BatchPrediction]] =
      None,
    nextToken: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse = {
    import DescribeBatchPredictionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(
        nextToken.map(value => StringType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DescribeBatchPredictionsResponse.ReadOnly =
    zio.aws.machinelearning.model.DescribeBatchPredictionsResponse
      .wrap(buildAwsValue())
}
object DescribeBatchPredictionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.DescribeBatchPredictionsResponse =
      zio.aws.machinelearning.model.DescribeBatchPredictionsResponse(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def results
        : Option[List[zio.aws.machinelearning.model.BatchPrediction.ReadOnly]]
    def nextToken: Option[StringType]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.machinelearning.model.BatchPrediction.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
    def getNextToken: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse
  ) extends zio.aws.machinelearning.model.DescribeBatchPredictionsResponse.ReadOnly {
    override val results
        : Option[List[zio.aws.machinelearning.model.BatchPrediction.ReadOnly]] =
      scala
        .Option(impl.results())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.machinelearning.model.BatchPrediction.wrap(item)
          }.toList
        )
    override val nextToken: Option[StringType] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.machinelearning.model.primitives.StringType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse
  ): zio.aws.machinelearning.model.DescribeBatchPredictionsResponse.ReadOnly =
    new Wrapper(impl)
}
