package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class DeleteTagsResponse(
    resourceId: Option[EntityId] = None,
    resourceType: Option[zio.aws.machinelearning.model.TaggableResourceType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteTagsResponse = {
    import DeleteTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteTagsResponse
      .builder()
      .optionallyWith(
        resourceId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.DeleteTagsResponse.ReadOnly =
    zio.aws.machinelearning.model.DeleteTagsResponse.wrap(buildAwsValue())
}
object DeleteTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DeleteTagsResponse =
      zio.aws.machinelearning.model.DeleteTagsResponse(
        resourceId.map(value => value),
        resourceType.map(value => value)
      )
    def resourceId: Option[EntityId]
    def resourceType: Option[zio.aws.machinelearning.model.TaggableResourceType]
    def getResourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.TaggableResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteTagsResponse
  ) extends zio.aws.machinelearning.model.DeleteTagsResponse.ReadOnly {
    override val resourceId: Option[EntityId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val resourceType
        : Option[zio.aws.machinelearning.model.TaggableResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.machinelearning.model.TaggableResourceType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteTagsResponse
  ): zio.aws.machinelearning.model.DeleteTagsResponse.ReadOnly = new Wrapper(
    impl
  )
}
