package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class DescribeTagsResponse(
    resourceId: Option[EntityId] = None,
    resourceType: Option[zio.aws.machinelearning.model.TaggableResourceType] =
      None,
    tags: Option[Iterable[zio.aws.machinelearning.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse = {
    import DescribeTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse
      .builder()
      .optionallyWith(
        resourceId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly =
    zio.aws.machinelearning.model.DescribeTagsResponse.wrap(buildAwsValue())
}
object DescribeTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DescribeTagsResponse =
      zio.aws.machinelearning.model.DescribeTagsResponse(
        resourceId.map(value => value),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceId: Option[EntityId]
    def resourceType: Option[zio.aws.machinelearning.model.TaggableResourceType]
    def tags: Option[List[zio.aws.machinelearning.model.Tag.ReadOnly]]
    def getResourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.TaggableResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.machinelearning.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse
  ) extends zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly {
    override val resourceId: Option[EntityId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val resourceType
        : Option[zio.aws.machinelearning.model.TaggableResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.machinelearning.model.TaggableResourceType.wrap(value)
      )
    override val tags
        : Option[List[zio.aws.machinelearning.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.machinelearning.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse
  ): zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly = new Wrapper(
    impl
  )
}
