package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.{
  RDSDatabasePassword,
  RDSDatabaseUsername
}
import scala.jdk.CollectionConverters._
final case class RDSDatabaseCredentials(
    username: RDSDatabaseUsername,
    password: RDSDatabasePassword
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RDSDatabaseCredentials = {
    import RDSDatabaseCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RDSDatabaseCredentials
      .builder()
      .username(RDSDatabaseUsername.unwrap(username): java.lang.String)
      .password(RDSDatabasePassword.unwrap(password): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.RDSDatabaseCredentials.ReadOnly =
    zio.aws.machinelearning.model.RDSDatabaseCredentials.wrap(buildAwsValue())
}
object RDSDatabaseCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RDSDatabaseCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RDSDatabaseCredentials =
      zio.aws.machinelearning.model.RDSDatabaseCredentials(username, password)
    def username: RDSDatabaseUsername
    def password: RDSDatabasePassword
    def getUsername: ZIO[Any, Nothing, RDSDatabaseUsername] =
      ZIO.succeed(username)
    def getPassword: ZIO[Any, Nothing, RDSDatabasePassword] =
      ZIO.succeed(password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RDSDatabaseCredentials
  ) extends zio.aws.machinelearning.model.RDSDatabaseCredentials.ReadOnly {
    override val username: RDSDatabaseUsername =
      zio.aws.machinelearning.model.primitives
        .RDSDatabaseUsername(impl.username())
    override val password: RDSDatabasePassword =
      zio.aws.machinelearning.model.primitives
        .RDSDatabasePassword(impl.password())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RDSDatabaseCredentials
  ): zio.aws.machinelearning.model.RDSDatabaseCredentials.ReadOnly =
    new Wrapper(impl)
}
