package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class CreateDataSourceFromRedshiftResponse(
    dataSourceId: Option[EntityId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftResponse = {
    import CreateDataSourceFromRedshiftResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftResponse
      .builder()
      .optionallyWith(
        dataSourceId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse.ReadOnly =
    zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse
      .wrap(buildAwsValue())
}
object CreateDataSourceFromRedshiftResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse =
      zio.aws.machinelearning.model
        .CreateDataSourceFromRedshiftResponse(dataSourceId.map(value => value))
    def dataSourceId: Option[EntityId]
    def getDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftResponse
  ) extends zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse.ReadOnly {
    override val dataSourceId: Option[EntityId] = scala
      .Option(impl.dataSourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftResponse
  ): zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse.ReadOnly =
    new Wrapper(impl)
}
