package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class CreateBatchPredictionResponse(
    batchPredictionId: Option[EntityId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionResponse = {
    import CreateBatchPredictionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionResponse
      .builder()
      .optionallyWith(
        batchPredictionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.batchPredictionId)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.CreateBatchPredictionResponse.ReadOnly =
    zio.aws.machinelearning.model.CreateBatchPredictionResponse
      .wrap(buildAwsValue())
}
object CreateBatchPredictionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.CreateBatchPredictionResponse =
      zio.aws.machinelearning.model
        .CreateBatchPredictionResponse(batchPredictionId.map(value => value))
    def batchPredictionId: Option[EntityId]
    def getBatchPredictionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("batchPredictionId", batchPredictionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionResponse
  ) extends zio.aws.machinelearning.model.CreateBatchPredictionResponse.ReadOnly {
    override val batchPredictionId: Option[EntityId] = scala
      .Option(impl.batchPredictionId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionResponse
  ): zio.aws.machinelearning.model.CreateBatchPredictionResponse.ReadOnly =
    new Wrapper(impl)
}
