package zio.aws.machinelearning.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.machinelearning.model.primitives.{
  Message,
  S3Url,
  EpochTime,
  EntityId,
  LongType,
  PresignedS3Url,
  EntityName,
  AwsUserArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetEvaluationResponse(
    evaluationId: Optional[EntityId] = Optional.Absent,
    mlModelId: Optional[EntityId] = Optional.Absent,
    evaluationDataSourceId: Optional[EntityId] = Optional.Absent,
    inputDataLocationS3: Optional[S3Url] = Optional.Absent,
    createdByIamUser: Optional[AwsUserArn] = Optional.Absent,
    createdAt: Optional[EpochTime] = Optional.Absent,
    lastUpdatedAt: Optional[EpochTime] = Optional.Absent,
    name: Optional[EntityName] = Optional.Absent,
    status: Optional[zio.aws.machinelearning.model.EntityStatus] =
      Optional.Absent,
    performanceMetrics: Optional[
      zio.aws.machinelearning.model.PerformanceMetrics
    ] = Optional.Absent,
    logUri: Optional[PresignedS3Url] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    computeTime: Optional[LongType] = Optional.Absent,
    finishedAt: Optional[EpochTime] = Optional.Absent,
    startedAt: Optional[EpochTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse = {
    import GetEvaluationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse
      .builder()
      .optionallyWith(
        evaluationId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.evaluationId)
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .optionallyWith(
        evaluationDataSourceId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.evaluationDataSourceId)
      .optionallyWith(
        inputDataLocationS3.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.inputDataLocationS3)
      .optionallyWith(
        createdByIamUser.map(value =>
          AwsUserArn.unwrap(value): java.lang.String
        )
      )(_.createdByIamUser)
      .optionallyWith(createdAt.map(value => EpochTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(performanceMetrics.map(value => value.buildAwsValue()))(
        _.performanceMetrics
      )
      .optionallyWith(
        logUri.map(value => PresignedS3Url.unwrap(value): java.lang.String)
      )(_.logUri)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        computeTime.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.computeTime)
      .optionallyWith(
        finishedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.finishedAt)
      .optionallyWith(startedAt.map(value => EpochTime.unwrap(value): Instant))(
        _.startedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly =
    zio.aws.machinelearning.model.GetEvaluationResponse.wrap(buildAwsValue())
}
object GetEvaluationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetEvaluationResponse =
      zio.aws.machinelearning.model.GetEvaluationResponse(
        evaluationId.map(value => value),
        mlModelId.map(value => value),
        evaluationDataSourceId.map(value => value),
        inputDataLocationS3.map(value => value),
        createdByIamUser.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        status.map(value => value),
        performanceMetrics.map(value => value.asEditable),
        logUri.map(value => value),
        message.map(value => value),
        computeTime.map(value => value),
        finishedAt.map(value => value),
        startedAt.map(value => value)
      )
    def evaluationId: Optional[EntityId]
    def mlModelId: Optional[EntityId]
    def evaluationDataSourceId: Optional[EntityId]
    def inputDataLocationS3: Optional[S3Url]
    def createdByIamUser: Optional[AwsUserArn]
    def createdAt: Optional[EpochTime]
    def lastUpdatedAt: Optional[EpochTime]
    def name: Optional[EntityName]
    def status: Optional[zio.aws.machinelearning.model.EntityStatus]
    def performanceMetrics
        : Optional[zio.aws.machinelearning.model.PerformanceMetrics.ReadOnly]
    def logUri: Optional[PresignedS3Url]
    def message: Optional[Message]
    def computeTime: Optional[LongType]
    def finishedAt: Optional[EpochTime]
    def startedAt: Optional[EpochTime]
    def getEvaluationId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("evaluationId", evaluationId)
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
    def getEvaluationDataSourceId: ZIO[Any, AwsError, EntityId] = AwsError
      .unwrapOptionField("evaluationDataSourceId", evaluationDataSourceId)
    def getInputDataLocationS3: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("inputDataLocationS3", inputDataLocationS3)
    def getCreatedByIamUser: ZIO[Any, AwsError, AwsUserArn] =
      AwsError.unwrapOptionField("createdByIamUser", createdByIamUser)
    def getCreatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.EntityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getPerformanceMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.PerformanceMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("performanceMetrics", performanceMetrics)
    def getLogUri: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getComputeTime: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("computeTime", computeTime)
    def getFinishedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("finishedAt", finishedAt)
    def getStartedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse
  ) extends zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly {
    override val evaluationId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val mlModelId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val evaluationDataSourceId: Optional[EntityId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationDataSourceId())
        .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val inputDataLocationS3: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDataLocationS3())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val createdByIamUser: Optional[AwsUserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.createdByIamUser())
      .map(value => zio.aws.machinelearning.model.primitives.AwsUserArn(value))
    override val createdAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val lastUpdatedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val name: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val status: Optional[zio.aws.machinelearning.model.EntityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.machinelearning.model.EntityStatus.wrap(value))
    override val performanceMetrics
        : Optional[zio.aws.machinelearning.model.PerformanceMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceMetrics())
        .map(value =>
          zio.aws.machinelearning.model.PerformanceMetrics.wrap(value)
        )
    override val logUri: Optional[PresignedS3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.logUri())
      .map(value =>
        zio.aws.machinelearning.model.primitives.PresignedS3Url(value)
      )
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.machinelearning.model.primitives.Message(value))
    override val computeTime: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.computeTime())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val finishedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.finishedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val startedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse
  ): zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly = new Wrapper(
    impl
  )
}
