package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  EDPServiceRole,
  EDPResourceRole,
  RDSDatabaseUsername,
  EDPPipelineId,
  RDSSelectSqlQuery
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RDSMetadata(
    database: Optional[zio.aws.machinelearning.model.RDSDatabase] =
      Optional.Absent,
    databaseUserName: Optional[RDSDatabaseUsername] = Optional.Absent,
    selectSqlQuery: Optional[RDSSelectSqlQuery] = Optional.Absent,
    resourceRole: Optional[EDPResourceRole] = Optional.Absent,
    serviceRole: Optional[EDPServiceRole] = Optional.Absent,
    dataPipelineId: Optional[EDPPipelineId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RDSMetadata = {
    import RDSMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RDSMetadata
      .builder()
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .optionallyWith(
        databaseUserName.map(value =>
          RDSDatabaseUsername.unwrap(value): java.lang.String
        )
      )(_.databaseUserName)
      .optionallyWith(
        selectSqlQuery.map(value =>
          RDSSelectSqlQuery.unwrap(value): java.lang.String
        )
      )(_.selectSqlQuery)
      .optionallyWith(
        resourceRole.map(value =>
          EDPResourceRole.unwrap(value): java.lang.String
        )
      )(_.resourceRole)
      .optionallyWith(
        serviceRole.map(value => EDPServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(
        dataPipelineId.map(value =>
          EDPPipelineId.unwrap(value): java.lang.String
        )
      )(_.dataPipelineId)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.RDSMetadata.ReadOnly =
    zio.aws.machinelearning.model.RDSMetadata.wrap(buildAwsValue())
}
object RDSMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RDSMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RDSMetadata =
      zio.aws.machinelearning.model.RDSMetadata(
        database.map(value => value.asEditable),
        databaseUserName.map(value => value),
        selectSqlQuery.map(value => value),
        resourceRole.map(value => value),
        serviceRole.map(value => value),
        dataPipelineId.map(value => value)
      )
    def database: Optional[zio.aws.machinelearning.model.RDSDatabase.ReadOnly]
    def databaseUserName: Optional[RDSDatabaseUsername]
    def selectSqlQuery: Optional[RDSSelectSqlQuery]
    def resourceRole: Optional[EDPResourceRole]
    def serviceRole: Optional[EDPServiceRole]
    def dataPipelineId: Optional[EDPPipelineId]
    def getDatabase: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RDSDatabase.ReadOnly
    ] = AwsError.unwrapOptionField("database", database)
    def getDatabaseUserName: ZIO[Any, AwsError, RDSDatabaseUsername] =
      AwsError.unwrapOptionField("databaseUserName", databaseUserName)
    def getSelectSqlQuery: ZIO[Any, AwsError, RDSSelectSqlQuery] =
      AwsError.unwrapOptionField("selectSqlQuery", selectSqlQuery)
    def getResourceRole: ZIO[Any, AwsError, EDPResourceRole] =
      AwsError.unwrapOptionField("resourceRole", resourceRole)
    def getServiceRole: ZIO[Any, AwsError, EDPServiceRole] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getDataPipelineId: ZIO[Any, AwsError, EDPPipelineId] =
      AwsError.unwrapOptionField("dataPipelineId", dataPipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RDSMetadata
  ) extends zio.aws.machinelearning.model.RDSMetadata.ReadOnly {
    override val database
        : Optional[zio.aws.machinelearning.model.RDSDatabase.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.database())
        .map(value => zio.aws.machinelearning.model.RDSDatabase.wrap(value))
    override val databaseUserName: Optional[RDSDatabaseUsername] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseUserName())
        .map(value =>
          zio.aws.machinelearning.model.primitives.RDSDatabaseUsername(value)
        )
    override val selectSqlQuery: Optional[RDSSelectSqlQuery] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectSqlQuery())
        .map(value =>
          zio.aws.machinelearning.model.primitives.RDSSelectSqlQuery(value)
        )
    override val resourceRole: Optional[EDPResourceRole] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceRole())
      .map(value =>
        zio.aws.machinelearning.model.primitives.EDPResourceRole(value)
      )
    override val serviceRole: Optional[EDPServiceRole] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value =>
        zio.aws.machinelearning.model.primitives.EDPServiceRole(value)
      )
    override val dataPipelineId: Optional[EDPPipelineId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataPipelineId())
      .map(value =>
        zio.aws.machinelearning.model.primitives.EDPPipelineId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RDSMetadata
  ): zio.aws.machinelearning.model.RDSMetadata.ReadOnly = new Wrapper(impl)
}
