package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  ComputeStatistics,
  EntityName,
  EntityId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDataSourceFromS3Request(
    dataSourceId: EntityId,
    dataSourceName: Optional[EntityName] = Optional.Absent,
    dataSpec: zio.aws.machinelearning.model.S3DataSpec,
    computeStatistics: Optional[ComputeStatistics] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request = {
    import CreateDataSourceFromS3Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request
      .builder()
      .dataSourceId(EntityId.unwrap(dataSourceId): java.lang.String)
      .optionallyWith(
        dataSourceName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.dataSourceName)
      .dataSpec(dataSpec.buildAwsValue())
      .optionallyWith(
        computeStatistics.map(value =>
          ComputeStatistics.unwrap(value): java.lang.Boolean
        )
      )(_.computeStatistics)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.CreateDataSourceFromS3Request.ReadOnly =
    zio.aws.machinelearning.model.CreateDataSourceFromS3Request
      .wrap(buildAwsValue())
}
object CreateDataSourceFromS3Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.CreateDataSourceFromS3Request =
      zio.aws.machinelearning.model.CreateDataSourceFromS3Request(
        dataSourceId,
        dataSourceName.map(value => value),
        dataSpec.asEditable,
        computeStatistics.map(value => value)
      )
    def dataSourceId: EntityId
    def dataSourceName: Optional[EntityName]
    def dataSpec: zio.aws.machinelearning.model.S3DataSpec.ReadOnly
    def computeStatistics: Optional[ComputeStatistics]
    def getDataSourceId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(dataSourceId)
    def getDataSourceName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("dataSourceName", dataSourceName)
    def getDataSpec
        : ZIO[Any, Nothing, zio.aws.machinelearning.model.S3DataSpec.ReadOnly] =
      ZIO.succeed(dataSpec)
    def getComputeStatistics: ZIO[Any, AwsError, ComputeStatistics] =
      AwsError.unwrapOptionField("computeStatistics", computeStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request
  ) extends zio.aws.machinelearning.model.CreateDataSourceFromS3Request.ReadOnly {
    override val dataSourceId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.dataSourceId())
    override val dataSourceName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceName())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val dataSpec: zio.aws.machinelearning.model.S3DataSpec.ReadOnly =
      zio.aws.machinelearning.model.S3DataSpec.wrap(impl.dataSpec())
    override val computeStatistics: Optional[ComputeStatistics] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeStatistics())
        .map(value =>
          zio.aws.machinelearning.model.primitives.ComputeStatistics(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request
  ): zio.aws.machinelearning.model.CreateDataSourceFromS3Request.ReadOnly =
    new Wrapper(impl)
}
