package zio.aws.machinelearning.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.machinelearning.model.primitives.{
  DataSchema,
  Message,
  DataRearrangement,
  S3Url,
  RoleARN,
  EpochTime,
  EntityId,
  LongType,
  ComputeStatistics,
  PresignedS3Url,
  EntityName,
  AwsUserArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetDataSourceResponse(
    dataSourceId: Optional[EntityId] = Optional.Absent,
    dataLocationS3: Optional[S3Url] = Optional.Absent,
    dataRearrangement: Optional[DataRearrangement] = Optional.Absent,
    createdByIamUser: Optional[AwsUserArn] = Optional.Absent,
    createdAt: Optional[EpochTime] = Optional.Absent,
    lastUpdatedAt: Optional[EpochTime] = Optional.Absent,
    dataSizeInBytes: Optional[LongType] = Optional.Absent,
    numberOfFiles: Optional[LongType] = Optional.Absent,
    name: Optional[EntityName] = Optional.Absent,
    status: Optional[zio.aws.machinelearning.model.EntityStatus] =
      Optional.Absent,
    logUri: Optional[PresignedS3Url] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    redshiftMetadata: Optional[zio.aws.machinelearning.model.RedshiftMetadata] =
      Optional.Absent,
    rdsMetadata: Optional[zio.aws.machinelearning.model.RDSMetadata] =
      Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent,
    computeStatistics: Optional[ComputeStatistics] = Optional.Absent,
    computeTime: Optional[LongType] = Optional.Absent,
    finishedAt: Optional[EpochTime] = Optional.Absent,
    startedAt: Optional[EpochTime] = Optional.Absent,
    dataSourceSchema: Optional[DataSchema] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse = {
    import GetDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse
      .builder()
      .optionallyWith(
        dataSourceId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .optionallyWith(
        dataLocationS3.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.dataLocationS3)
      .optionallyWith(
        dataRearrangement.map(value =>
          DataRearrangement.unwrap(value): java.lang.String
        )
      )(_.dataRearrangement)
      .optionallyWith(
        createdByIamUser.map(value =>
          AwsUserArn.unwrap(value): java.lang.String
        )
      )(_.createdByIamUser)
      .optionallyWith(createdAt.map(value => EpochTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        dataSizeInBytes.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.dataSizeInBytes)
      .optionallyWith(
        numberOfFiles.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.numberOfFiles)
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        logUri.map(value => PresignedS3Url.unwrap(value): java.lang.String)
      )(_.logUri)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(redshiftMetadata.map(value => value.buildAwsValue()))(
        _.redshiftMetadata
      )
      .optionallyWith(rdsMetadata.map(value => value.buildAwsValue()))(
        _.rdsMetadata
      )
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        computeStatistics.map(value =>
          ComputeStatistics.unwrap(value): java.lang.Boolean
        )
      )(_.computeStatistics)
      .optionallyWith(
        computeTime.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.computeTime)
      .optionallyWith(
        finishedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.finishedAt)
      .optionallyWith(startedAt.map(value => EpochTime.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        dataSourceSchema.map(value =>
          DataSchema.unwrap(value): java.lang.String
        )
      )(_.dataSourceSchema)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly =
    zio.aws.machinelearning.model.GetDataSourceResponse.wrap(buildAwsValue())
}
object GetDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetDataSourceResponse =
      zio.aws.machinelearning.model.GetDataSourceResponse(
        dataSourceId.map(value => value),
        dataLocationS3.map(value => value),
        dataRearrangement.map(value => value),
        createdByIamUser.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        dataSizeInBytes.map(value => value),
        numberOfFiles.map(value => value),
        name.map(value => value),
        status.map(value => value),
        logUri.map(value => value),
        message.map(value => value),
        redshiftMetadata.map(value => value.asEditable),
        rdsMetadata.map(value => value.asEditable),
        roleARN.map(value => value),
        computeStatistics.map(value => value),
        computeTime.map(value => value),
        finishedAt.map(value => value),
        startedAt.map(value => value),
        dataSourceSchema.map(value => value)
      )
    def dataSourceId: Optional[EntityId]
    def dataLocationS3: Optional[S3Url]
    def dataRearrangement: Optional[DataRearrangement]
    def createdByIamUser: Optional[AwsUserArn]
    def createdAt: Optional[EpochTime]
    def lastUpdatedAt: Optional[EpochTime]
    def dataSizeInBytes: Optional[LongType]
    def numberOfFiles: Optional[LongType]
    def name: Optional[EntityName]
    def status: Optional[zio.aws.machinelearning.model.EntityStatus]
    def logUri: Optional[PresignedS3Url]
    def message: Optional[Message]
    def redshiftMetadata
        : Optional[zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly]
    def rdsMetadata
        : Optional[zio.aws.machinelearning.model.RDSMetadata.ReadOnly]
    def roleARN: Optional[RoleARN]
    def computeStatistics: Optional[ComputeStatistics]
    def computeTime: Optional[LongType]
    def finishedAt: Optional[EpochTime]
    def startedAt: Optional[EpochTime]
    def dataSourceSchema: Optional[DataSchema]
    def getDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
    def getDataLocationS3: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("dataLocationS3", dataLocationS3)
    def getDataRearrangement: ZIO[Any, AwsError, DataRearrangement] =
      AwsError.unwrapOptionField("dataRearrangement", dataRearrangement)
    def getCreatedByIamUser: ZIO[Any, AwsError, AwsUserArn] =
      AwsError.unwrapOptionField("createdByIamUser", createdByIamUser)
    def getCreatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getDataSizeInBytes: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("dataSizeInBytes", dataSizeInBytes)
    def getNumberOfFiles: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("numberOfFiles", numberOfFiles)
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.EntityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLogUri: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getRedshiftMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("redshiftMetadata", redshiftMetadata)
    def getRdsMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RDSMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("rdsMetadata", rdsMetadata)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getComputeStatistics: ZIO[Any, AwsError, ComputeStatistics] =
      AwsError.unwrapOptionField("computeStatistics", computeStatistics)
    def getComputeTime: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("computeTime", computeTime)
    def getFinishedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("finishedAt", finishedAt)
    def getStartedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getDataSourceSchema: ZIO[Any, AwsError, DataSchema] =
      AwsError.unwrapOptionField("dataSourceSchema", dataSourceSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse
  ) extends zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly {
    override val dataSourceId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val dataLocationS3: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.dataLocationS3())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val dataRearrangement: Optional[DataRearrangement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataRearrangement())
        .map(value =>
          zio.aws.machinelearning.model.primitives.DataRearrangement(value)
        )
    override val createdByIamUser: Optional[AwsUserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.createdByIamUser())
      .map(value => zio.aws.machinelearning.model.primitives.AwsUserArn(value))
    override val createdAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val lastUpdatedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val dataSizeInBytes: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSizeInBytes())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val numberOfFiles: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfFiles())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val name: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val status: Optional[zio.aws.machinelearning.model.EntityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.machinelearning.model.EntityStatus.wrap(value))
    override val logUri: Optional[PresignedS3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.logUri())
      .map(value =>
        zio.aws.machinelearning.model.primitives.PresignedS3Url(value)
      )
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.machinelearning.model.primitives.Message(value))
    override val redshiftMetadata
        : Optional[zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redshiftMetadata())
        .map(value =>
          zio.aws.machinelearning.model.RedshiftMetadata.wrap(value)
        )
    override val rdsMetadata
        : Optional[zio.aws.machinelearning.model.RDSMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rdsMetadata())
        .map(value => zio.aws.machinelearning.model.RDSMetadata.wrap(value))
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.machinelearning.model.primitives.RoleARN(value))
    override val computeStatistics: Optional[ComputeStatistics] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeStatistics())
        .map(value =>
          zio.aws.machinelearning.model.primitives.ComputeStatistics(value)
        )
    override val computeTime: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.computeTime())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val finishedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.finishedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val startedAt: Optional[EpochTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val dataSourceSchema: Optional[DataSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceSchema())
      .map(value => zio.aws.machinelearning.model.primitives.DataSchema(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse
  ): zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
