package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.{
  RDSDatabaseName,
  RDSInstanceIdentifier
}
import scala.jdk.CollectionConverters._
final case class RDSDatabase(
    instanceIdentifier: RDSInstanceIdentifier,
    databaseName: RDSDatabaseName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RDSDatabase = {
    import RDSDatabase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RDSDatabase
      .builder()
      .instanceIdentifier(
        RDSInstanceIdentifier.unwrap(instanceIdentifier): java.lang.String
      )
      .databaseName(RDSDatabaseName.unwrap(databaseName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.RDSDatabase.ReadOnly =
    zio.aws.machinelearning.model.RDSDatabase.wrap(buildAwsValue())
}
object RDSDatabase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RDSDatabase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RDSDatabase =
      zio.aws.machinelearning.model
        .RDSDatabase(instanceIdentifier, databaseName)
    def instanceIdentifier: RDSInstanceIdentifier
    def databaseName: RDSDatabaseName
    def getInstanceIdentifier: ZIO[Any, Nothing, RDSInstanceIdentifier] =
      ZIO.succeed(instanceIdentifier)
    def getDatabaseName: ZIO[Any, Nothing, RDSDatabaseName] =
      ZIO.succeed(databaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RDSDatabase
  ) extends zio.aws.machinelearning.model.RDSDatabase.ReadOnly {
    override val instanceIdentifier: RDSInstanceIdentifier =
      zio.aws.machinelearning.model.primitives
        .RDSInstanceIdentifier(impl.instanceIdentifier())
    override val databaseName: RDSDatabaseName =
      zio.aws.machinelearning.model.primitives
        .RDSDatabaseName(impl.databaseName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RDSDatabase
  ): zio.aws.machinelearning.model.RDSDatabase.ReadOnly = new Wrapper(impl)
}
