package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  ComputeStatistics,
  RoleARN,
  EntityName,
  EntityId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDataSourceFromRedshiftRequest(
    dataSourceId: EntityId,
    dataSourceName: Optional[EntityName] = Optional.Absent,
    dataSpec: zio.aws.machinelearning.model.RedshiftDataSpec,
    roleARN: RoleARN,
    computeStatistics: Optional[ComputeStatistics] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest = {
    import CreateDataSourceFromRedshiftRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest
      .builder()
      .dataSourceId(EntityId.unwrap(dataSourceId): java.lang.String)
      .optionallyWith(
        dataSourceName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.dataSourceName)
      .dataSpec(dataSpec.buildAwsValue())
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .optionallyWith(
        computeStatistics.map(value =>
          ComputeStatistics.unwrap(value): java.lang.Boolean
        )
      )(_.computeStatistics)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.CreateDataSourceFromRedshiftRequest.ReadOnly =
    zio.aws.machinelearning.model.CreateDataSourceFromRedshiftRequest
      .wrap(buildAwsValue())
}
object CreateDataSourceFromRedshiftRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.CreateDataSourceFromRedshiftRequest =
      zio.aws.machinelearning.model.CreateDataSourceFromRedshiftRequest(
        dataSourceId,
        dataSourceName.map(value => value),
        dataSpec.asEditable,
        roleARN,
        computeStatistics.map(value => value)
      )
    def dataSourceId: EntityId
    def dataSourceName: Optional[EntityName]
    def dataSpec: zio.aws.machinelearning.model.RedshiftDataSpec.ReadOnly
    def roleARN: RoleARN
    def computeStatistics: Optional[ComputeStatistics]
    def getDataSourceId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(dataSourceId)
    def getDataSourceName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("dataSourceName", dataSourceName)
    def getDataSpec: ZIO[
      Any,
      Nothing,
      zio.aws.machinelearning.model.RedshiftDataSpec.ReadOnly
    ] = ZIO.succeed(dataSpec)
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getComputeStatistics: ZIO[Any, AwsError, ComputeStatistics] =
      AwsError.unwrapOptionField("computeStatistics", computeStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest
  ) extends zio.aws.machinelearning.model.CreateDataSourceFromRedshiftRequest.ReadOnly {
    override val dataSourceId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.dataSourceId())
    override val dataSourceName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceName())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val dataSpec
        : zio.aws.machinelearning.model.RedshiftDataSpec.ReadOnly =
      zio.aws.machinelearning.model.RedshiftDataSpec.wrap(impl.dataSpec())
    override val roleARN: RoleARN =
      zio.aws.machinelearning.model.primitives.RoleARN(impl.roleARN())
    override val computeStatistics: Optional[ComputeStatistics] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeStatistics())
        .map(value =>
          zio.aws.machinelearning.model.primitives.ComputeStatistics(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest
  ): zio.aws.machinelearning.model.CreateDataSourceFromRedshiftRequest.ReadOnly =
    new Wrapper(impl)
}
