package zio.aws.machinelearning.model
import scala.jdk.CollectionConverters._
sealed trait RealtimeEndpointStatus {
  def unwrap: software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus
}
object RealtimeEndpointStatus {
  def wrap(
      value: software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus
  ): zio.aws.machinelearning.model.RealtimeEndpointStatus = value match {
    case software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.machinelearning.model.RealtimeEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus =
      software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE
      extends zio.aws.machinelearning.model.RealtimeEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus =
      software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus.NONE
  }
  case object READY
      extends zio.aws.machinelearning.model.RealtimeEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus =
      software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus.READY
  }
  case object UPDATING
      extends zio.aws.machinelearning.model.RealtimeEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus =
      software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus.UPDATING
  }
  case object FAILED
      extends zio.aws.machinelearning.model.RealtimeEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus =
      software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus.FAILED
  }
}
