package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.StringType
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeMlModelsResponse(
    results: Optional[Iterable[zio.aws.machinelearning.model.MLModel]] =
      Optional.Absent,
    nextToken: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse = {
    import DescribeMlModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly =
    zio.aws.machinelearning.model.DescribeMlModelsResponse.wrap(buildAwsValue())
}
object DescribeMlModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DescribeMlModelsResponse =
      zio.aws.machinelearning.model.DescribeMlModelsResponse(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def results: Optional[List[zio.aws.machinelearning.model.MLModel.ReadOnly]]
    def nextToken: Optional[StringType]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.machinelearning.model.MLModel.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
    def getNextToken: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse
  ) extends zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly {
    override val results
        : Optional[List[zio.aws.machinelearning.model.MLModel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.results())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.machinelearning.model.MLModel.wrap(item)
          }.toList
        )
    override val nextToken: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse
  ): zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly =
    new Wrapper(impl)
}
