package zio.aws.machinelearning
import zio.aws.machinelearning.model.GetMlModelResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.machinelearning.model.{
  DescribeEvaluationsRequest,
  CreateEvaluationRequest,
  DescribeBatchPredictionsRequest,
  UpdateDataSourceRequest,
  DeleteTagsRequest,
  UpdateBatchPredictionRequest,
  PredictRequest,
  CreateDataSourceFromRdsRequest,
  GetEvaluationRequest,
  CreateBatchPredictionRequest,
  GetBatchPredictionRequest,
  DeleteRealtimeEndpointRequest,
  UpdateMlModelRequest,
  DescribeMlModelsRequest,
  DeleteBatchPredictionRequest,
  UpdateEvaluationRequest,
  GetDataSourceRequest,
  AddTagsRequest,
  DeleteMlModelRequest,
  DeleteEvaluationRequest,
  GetMlModelRequest,
  DescribeDataSourcesRequest,
  DescribeTagsRequest,
  DeleteDataSourceRequest,
  CreateDataSourceFromRedshiftRequest,
  CreateDataSourceFromS3Request,
  CreateRealtimeEndpointRequest,
  CreateMlModelRequest
}
object MachineLearningMock extends Mock[MachineLearning] {
  object UpdateBatchPrediction
      extends Effect[
        UpdateBatchPredictionRequest,
        AwsError,
        zio.aws.machinelearning.model.UpdateBatchPredictionResponse.ReadOnly
      ]
  object DescribeTags
      extends Effect[
        DescribeTagsRequest,
        AwsError,
        zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly
      ]
  object CreateDataSourceFromS3
      extends Effect[
        CreateDataSourceFromS3Request,
        AwsError,
        zio.aws.machinelearning.model.CreateDataSourceFromS3Response.ReadOnly
      ]
  object GetDataSource
      extends Effect[
        GetDataSourceRequest,
        AwsError,
        zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly
      ]
  object DescribeEvaluations
      extends Stream[
        DescribeEvaluationsRequest,
        AwsError,
        zio.aws.machinelearning.model.Evaluation.ReadOnly
      ]
  object DescribeEvaluationsPaginated
      extends Effect[
        DescribeEvaluationsRequest,
        AwsError,
        zio.aws.machinelearning.model.DescribeEvaluationsResponse.ReadOnly
      ]
  object DeleteRealtimeEndpoint
      extends Effect[
        DeleteRealtimeEndpointRequest,
        AwsError,
        zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse.ReadOnly
      ]
  object AddTags
      extends Effect[
        AddTagsRequest,
        AwsError,
        zio.aws.machinelearning.model.AddTagsResponse.ReadOnly
      ]
  object DeleteMLModel
      extends Effect[
        DeleteMlModelRequest,
        AwsError,
        zio.aws.machinelearning.model.DeleteMlModelResponse.ReadOnly
      ]
  object Predict
      extends Effect[
        PredictRequest,
        AwsError,
        zio.aws.machinelearning.model.PredictResponse.ReadOnly
      ]
  object CreateRealtimeEndpoint
      extends Effect[
        CreateRealtimeEndpointRequest,
        AwsError,
        zio.aws.machinelearning.model.CreateRealtimeEndpointResponse.ReadOnly
      ]
  object CreateMLModel
      extends Effect[
        CreateMlModelRequest,
        AwsError,
        zio.aws.machinelearning.model.CreateMlModelResponse.ReadOnly
      ]
  object CreateEvaluation
      extends Effect[
        CreateEvaluationRequest,
        AwsError,
        zio.aws.machinelearning.model.CreateEvaluationResponse.ReadOnly
      ]
  object UpdateEvaluation
      extends Effect[
        UpdateEvaluationRequest,
        AwsError,
        zio.aws.machinelearning.model.UpdateEvaluationResponse.ReadOnly
      ]
  object CreateDataSourceFromRedshift
      extends Effect[
        CreateDataSourceFromRedshiftRequest,
        AwsError,
        zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse.ReadOnly
      ]
  object GetEvaluation
      extends Effect[
        GetEvaluationRequest,
        AwsError,
        zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly
      ]
  object GetMLModel extends Effect[GetMlModelRequest, AwsError, ReadOnly]
  object CreateBatchPrediction
      extends Effect[
        CreateBatchPredictionRequest,
        AwsError,
        zio.aws.machinelearning.model.CreateBatchPredictionResponse.ReadOnly
      ]
  object UpdateDataSource
      extends Effect[
        UpdateDataSourceRequest,
        AwsError,
        zio.aws.machinelearning.model.UpdateDataSourceResponse.ReadOnly
      ]
  object DeleteDataSource
      extends Effect[
        DeleteDataSourceRequest,
        AwsError,
        zio.aws.machinelearning.model.DeleteDataSourceResponse.ReadOnly
      ]
  object DeleteBatchPrediction
      extends Effect[
        DeleteBatchPredictionRequest,
        AwsError,
        zio.aws.machinelearning.model.DeleteBatchPredictionResponse.ReadOnly
      ]
  object DescribeMLModels
      extends Stream[
        DescribeMlModelsRequest,
        AwsError,
        zio.aws.machinelearning.model.MLModel.ReadOnly
      ]
  object DescribeMLModelsPaginated
      extends Effect[
        DescribeMlModelsRequest,
        AwsError,
        zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly
      ]
  object DeleteEvaluation
      extends Effect[
        DeleteEvaluationRequest,
        AwsError,
        zio.aws.machinelearning.model.DeleteEvaluationResponse.ReadOnly
      ]
  object CreateDataSourceFromRDS
      extends Effect[
        CreateDataSourceFromRdsRequest,
        AwsError,
        zio.aws.machinelearning.model.CreateDataSourceFromRdsResponse.ReadOnly
      ]
  object DescribeBatchPredictions
      extends Stream[
        DescribeBatchPredictionsRequest,
        AwsError,
        zio.aws.machinelearning.model.BatchPrediction.ReadOnly
      ]
  object DescribeBatchPredictionsPaginated
      extends Effect[
        DescribeBatchPredictionsRequest,
        AwsError,
        zio.aws.machinelearning.model.DescribeBatchPredictionsResponse.ReadOnly
      ]
  object DescribeDataSources
      extends Stream[
        DescribeDataSourcesRequest,
        AwsError,
        zio.aws.machinelearning.model.DataSource.ReadOnly
      ]
  object DescribeDataSourcesPaginated
      extends Effect[
        DescribeDataSourcesRequest,
        AwsError,
        zio.aws.machinelearning.model.DescribeDataSourcesResponse.ReadOnly
      ]
  object DeleteTags
      extends Effect[
        DeleteTagsRequest,
        AwsError,
        zio.aws.machinelearning.model.DeleteTagsResponse.ReadOnly
      ]
  object UpdateMLModel
      extends Effect[
        UpdateMlModelRequest,
        AwsError,
        zio.aws.machinelearning.model.UpdateMlModelResponse.ReadOnly
      ]
  object GetBatchPrediction
      extends Effect[
        GetBatchPredictionRequest,
        AwsError,
        zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MachineLearning] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new MachineLearning {
          val api: MachineLearningAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : MachineLearning = this
          def updateBatchPrediction(request: UpdateBatchPredictionRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.UpdateBatchPredictionResponse.ReadOnly
          ] = proxy(UpdateBatchPrediction, request)
          def describeTags(request: DescribeTagsRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly
          ] = proxy(DescribeTags, request)
          def createDataSourceFromS3(
              request: CreateDataSourceFromS3Request
          ): IO[
            AwsError,
            zio.aws.machinelearning.model.CreateDataSourceFromS3Response.ReadOnly
          ] = proxy(CreateDataSourceFromS3, request)
          def getDataSource(request: GetDataSourceRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly
          ] = proxy(GetDataSource, request)
          def describeEvaluations(request: DescribeEvaluationsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.machinelearning.model.Evaluation.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeEvaluations, request))
          def describeEvaluationsPaginated(
              request: DescribeEvaluationsRequest
          ): IO[
            AwsError,
            zio.aws.machinelearning.model.DescribeEvaluationsResponse.ReadOnly
          ] = proxy(DescribeEvaluationsPaginated, request)
          def deleteRealtimeEndpoint(
              request: DeleteRealtimeEndpointRequest
          ): IO[
            AwsError,
            zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse.ReadOnly
          ] = proxy(DeleteRealtimeEndpoint, request)
          def addTags(request: AddTagsRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.AddTagsResponse.ReadOnly
          ] = proxy(AddTags, request)
          def deleteMLModel(request: DeleteMlModelRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.DeleteMlModelResponse.ReadOnly
          ] = proxy(DeleteMLModel, request)
          def predict(request: PredictRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.PredictResponse.ReadOnly
          ] = proxy(Predict, request)
          def createRealtimeEndpoint(
              request: CreateRealtimeEndpointRequest
          ): IO[
            AwsError,
            zio.aws.machinelearning.model.CreateRealtimeEndpointResponse.ReadOnly
          ] = proxy(CreateRealtimeEndpoint, request)
          def createMLModel(request: CreateMlModelRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.CreateMlModelResponse.ReadOnly
          ] = proxy(CreateMLModel, request)
          def createEvaluation(request: CreateEvaluationRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.CreateEvaluationResponse.ReadOnly
          ] = proxy(CreateEvaluation, request)
          def updateEvaluation(request: UpdateEvaluationRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.UpdateEvaluationResponse.ReadOnly
          ] = proxy(UpdateEvaluation, request)
          def createDataSourceFromRedshift(
              request: CreateDataSourceFromRedshiftRequest
          ): IO[
            AwsError,
            zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse.ReadOnly
          ] = proxy(CreateDataSourceFromRedshift, request)
          def getEvaluation(request: GetEvaluationRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly
          ] = proxy(GetEvaluation, request)
          def getMLModel(request: GetMlModelRequest): IO[AwsError, ReadOnly] =
            proxy(GetMLModel, request)
          def createBatchPrediction(request: CreateBatchPredictionRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.CreateBatchPredictionResponse.ReadOnly
          ] = proxy(CreateBatchPrediction, request)
          def updateDataSource(request: UpdateDataSourceRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.UpdateDataSourceResponse.ReadOnly
          ] = proxy(UpdateDataSource, request)
          def deleteDataSource(request: DeleteDataSourceRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.DeleteDataSourceResponse.ReadOnly
          ] = proxy(DeleteDataSource, request)
          def deleteBatchPrediction(request: DeleteBatchPredictionRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.DeleteBatchPredictionResponse.ReadOnly
          ] = proxy(DeleteBatchPrediction, request)
          def describeMLModels(request: DescribeMlModelsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.machinelearning.model.MLModel.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeMLModels, request))
          def describeMLModelsPaginated(request: DescribeMlModelsRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly
          ] = proxy(DescribeMLModelsPaginated, request)
          def deleteEvaluation(request: DeleteEvaluationRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.DeleteEvaluationResponse.ReadOnly
          ] = proxy(DeleteEvaluation, request)
          def createDataSourceFromRDS(
              request: CreateDataSourceFromRdsRequest
          ): IO[
            AwsError,
            zio.aws.machinelearning.model.CreateDataSourceFromRdsResponse.ReadOnly
          ] = proxy(CreateDataSourceFromRDS, request)
          def describeBatchPredictions(
              request: DescribeBatchPredictionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.machinelearning.model.BatchPrediction.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeBatchPredictions, request))
          def describeBatchPredictionsPaginated(
              request: DescribeBatchPredictionsRequest
          ): IO[
            AwsError,
            zio.aws.machinelearning.model.DescribeBatchPredictionsResponse.ReadOnly
          ] = proxy(DescribeBatchPredictionsPaginated, request)
          def describeDataSources(request: DescribeDataSourcesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.machinelearning.model.DataSource.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDataSources, request))
          def describeDataSourcesPaginated(
              request: DescribeDataSourcesRequest
          ): IO[
            AwsError,
            zio.aws.machinelearning.model.DescribeDataSourcesResponse.ReadOnly
          ] = proxy(DescribeDataSourcesPaginated, request)
          def deleteTags(request: DeleteTagsRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.DeleteTagsResponse.ReadOnly
          ] = proxy(DeleteTags, request)
          def updateMLModel(request: UpdateMlModelRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.UpdateMlModelResponse.ReadOnly
          ] = proxy(UpdateMLModel, request)
          def getBatchPrediction(request: GetBatchPredictionRequest): IO[
            AwsError,
            zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly
          ] = proxy(GetBatchPrediction, request)
        }
      }
    }
    .toLayer
}
