package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  PerformanceMetricsPropertyValue,
  PerformanceMetricsPropertyKey
}
import scala.jdk.CollectionConverters._
final case class PerformanceMetrics(
    properties: Option[
      Map[PerformanceMetricsPropertyKey, PerformanceMetricsPropertyValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.PerformanceMetrics = {
    import PerformanceMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.PerformanceMetrics
      .builder()
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (PerformanceMetricsPropertyKey.unwrap(
                key
              ): java.lang.String) -> (PerformanceMetricsPropertyValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.PerformanceMetrics.ReadOnly =
    zio.aws.machinelearning.model.PerformanceMetrics.wrap(buildAwsValue())
}
object PerformanceMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.PerformanceMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.PerformanceMetrics =
      zio.aws.machinelearning.model
        .PerformanceMetrics(properties.map(value => value))
    def properties: Option[
      Map[PerformanceMetricsPropertyKey, PerformanceMetricsPropertyValue]
    ]
    def getProperties: ZIO[Any, AwsError, Map[
      PerformanceMetricsPropertyKey,
      PerformanceMetricsPropertyValue
    ]] = AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.PerformanceMetrics
  ) extends zio.aws.machinelearning.model.PerformanceMetrics.ReadOnly {
    override val properties: Option[
      Map[PerformanceMetricsPropertyKey, PerformanceMetricsPropertyValue]
    ] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.machinelearning.model.primitives
              .PerformanceMetricsPropertyKey(
                key
              ) -> zio.aws.machinelearning.model.primitives
              .PerformanceMetricsPropertyValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.PerformanceMetrics
  ): zio.aws.machinelearning.model.PerformanceMetrics.ReadOnly = new Wrapper(
    impl
  )
}
