package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{Verbose, EntityId}
import scala.jdk.CollectionConverters._
final case class GetDataSourceRequest(
    dataSourceId: EntityId,
    verbose: Option[Verbose] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest = {
    import GetDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest
      .builder()
      .dataSourceId(EntityId.unwrap(dataSourceId): java.lang.String)
      .optionallyWith(
        verbose.map(value => Verbose.unwrap(value): java.lang.Boolean)
      )(_.verbose)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.GetDataSourceRequest.ReadOnly =
    zio.aws.machinelearning.model.GetDataSourceRequest.wrap(buildAwsValue())
}
object GetDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetDataSourceRequest =
      zio.aws.machinelearning.model
        .GetDataSourceRequest(dataSourceId, verbose.map(value => value))
    def dataSourceId: EntityId
    def verbose: Option[Verbose]
    def getDataSourceId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(dataSourceId)
    def getVerbose: ZIO[Any, AwsError, Verbose] =
      AwsError.unwrapOptionField("verbose", verbose)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest
  ) extends zio.aws.machinelearning.model.GetDataSourceRequest.ReadOnly {
    override val dataSourceId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.dataSourceId())
    override val verbose: Option[Verbose] = scala
      .Option(impl.verbose())
      .map(value => zio.aws.machinelearning.model.primitives.Verbose(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest
  ): zio.aws.machinelearning.model.GetDataSourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
