package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VsamAttributes(
    alternateKeys: Optional[Iterable[zio.aws.m2.model.AlternateKey]] =
      Optional.Absent,
    compressed: Optional[Boolean] = Optional.Absent,
    encoding: Optional[String] = Optional.Absent,
    format: String,
    primaryKey: Optional[zio.aws.m2.model.PrimaryKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.VsamAttributes = {
    import VsamAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.VsamAttributes
      .builder()
      .optionallyWith(
        alternateKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternateKeys)
      .optionallyWith(compressed.map(value => value: java.lang.Boolean))(
        _.compressed
      )
      .optionallyWith(encoding.map(value => value: java.lang.String))(
        _.encoding
      )
      .format(format: java.lang.String)
      .optionallyWith(primaryKey.map(value => value.buildAwsValue()))(
        _.primaryKey
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.VsamAttributes.ReadOnly =
    zio.aws.m2.model.VsamAttributes.wrap(buildAwsValue())
}
object VsamAttributes {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.m2.model.VsamAttributes] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.VsamAttributes =
      zio.aws.m2.model.VsamAttributes(
        alternateKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        compressed.map(value => value),
        encoding.map(value => value),
        format,
        primaryKey.map(value => value.asEditable)
      )
    def alternateKeys: Optional[List[zio.aws.m2.model.AlternateKey.ReadOnly]]
    def compressed: Optional[Boolean]
    def encoding: Optional[String]
    def format: String
    def primaryKey: Optional[zio.aws.m2.model.PrimaryKey.ReadOnly]
    def getAlternateKeys
        : ZIO[Any, AwsError, List[zio.aws.m2.model.AlternateKey.ReadOnly]] =
      AwsError.unwrapOptionField("alternateKeys", alternateKeys)
    def getCompressed: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("compressed", compressed)
    def getEncoding: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encoding", encoding)
    def getFormat: ZIO[Any, Nothing, String] = ZIO.succeed(format)
    def getPrimaryKey
        : ZIO[Any, AwsError, zio.aws.m2.model.PrimaryKey.ReadOnly] =
      AwsError.unwrapOptionField("primaryKey", primaryKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.VsamAttributes
  ) extends zio.aws.m2.model.VsamAttributes.ReadOnly {
    override val alternateKeys
        : Optional[List[zio.aws.m2.model.AlternateKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alternateKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.m2.model.AlternateKey.wrap(item)
          }.toList
        )
    override val compressed: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.compressed())
      .map(value => value: Boolean)
    override val encoding: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encoding())
      .map(value => value: String)
    override val format: String = impl.format(): String
    override val primaryKey: Optional[zio.aws.m2.model.PrimaryKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryKey())
        .map(value => zio.aws.m2.model.PrimaryKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.VsamAttributes
  ): zio.aws.m2.model.VsamAttributes.ReadOnly = new Wrapper(impl)
}
