package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ScriptBatchJobIdentifier(scriptName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ScriptBatchJobIdentifier = {
    import ScriptBatchJobIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ScriptBatchJobIdentifier
      .builder()
      .scriptName(scriptName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ScriptBatchJobIdentifier.ReadOnly =
    zio.aws.m2.model.ScriptBatchJobIdentifier.wrap(buildAwsValue())
}
object ScriptBatchJobIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ScriptBatchJobIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ScriptBatchJobIdentifier =
      zio.aws.m2.model.ScriptBatchJobIdentifier(scriptName)
    def scriptName: String
    def getScriptName: ZIO[Any, Nothing, String] = ZIO.succeed(scriptName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ScriptBatchJobIdentifier
  ) extends zio.aws.m2.model.ScriptBatchJobIdentifier.ReadOnly {
    override val scriptName: String = impl.scriptName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ScriptBatchJobIdentifier
  ): zio.aws.m2.model.ScriptBatchJobIdentifier.ReadOnly = new Wrapper(impl)
}
