package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PsAttributes(
    encoding: Optional[String] = Optional.Absent,
    format: String
) {
  def buildAwsValue(): software.amazon.awssdk.services.m2.model.PsAttributes = {
    import PsAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.PsAttributes
      .builder()
      .optionallyWith(encoding.map(value => value: java.lang.String))(
        _.encoding
      )
      .format(format: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.PsAttributes.ReadOnly =
    zio.aws.m2.model.PsAttributes.wrap(buildAwsValue())
}
object PsAttributes {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.m2.model.PsAttributes] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.PsAttributes =
      zio.aws.m2.model.PsAttributes(encoding.map(value => value), format)
    def encoding: Optional[String]
    def format: String
    def getEncoding: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encoding", encoding)
    def getFormat: ZIO[Any, Nothing, String] = ZIO.succeed(format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.PsAttributes
  ) extends zio.aws.m2.model.PsAttributes.ReadOnly {
    override val encoding: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encoding())
      .map(value => value: String)
    override val format: String = impl.format(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.PsAttributes
  ): zio.aws.m2.model.PsAttributes.ReadOnly = new Wrapper(impl)
}
