package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PoDetailAttributes(encoding: String, format: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.PoDetailAttributes = {
    import PoDetailAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.PoDetailAttributes
      .builder()
      .encoding(encoding: java.lang.String)
      .format(format: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.PoDetailAttributes.ReadOnly =
    zio.aws.m2.model.PoDetailAttributes.wrap(buildAwsValue())
}
object PoDetailAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.PoDetailAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.PoDetailAttributes =
      zio.aws.m2.model.PoDetailAttributes(encoding, format)
    def encoding: String
    def format: String
    def getEncoding: ZIO[Any, Nothing, String] = ZIO.succeed(encoding)
    def getFormat: ZIO[Any, Nothing, String] = ZIO.succeed(format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.PoDetailAttributes
  ) extends zio.aws.m2.model.PoDetailAttributes.ReadOnly {
    override val encoding: String = impl.encoding(): String
    override val format: String = impl.format(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.PoDetailAttributes
  ): zio.aws.m2.model.PoDetailAttributes.ReadOnly = new Wrapper(impl)
}
