package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.{String200, Identifier}
import scala.jdk.CollectionConverters._
final case class GetDataSetDetailsRequest(
    applicationId: Identifier,
    dataSetName: String200
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetDataSetDetailsRequest = {
    import GetDataSetDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetDataSetDetailsRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .dataSetName(String200.unwrap(dataSetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetDataSetDetailsRequest.ReadOnly =
    zio.aws.m2.model.GetDataSetDetailsRequest.wrap(buildAwsValue())
}
object GetDataSetDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetDataSetDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetDataSetDetailsRequest =
      zio.aws.m2.model.GetDataSetDetailsRequest(applicationId, dataSetName)
    def applicationId: Identifier
    def dataSetName: String200
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getDataSetName: ZIO[Any, Nothing, String200] = ZIO.succeed(dataSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetDataSetDetailsRequest
  ) extends zio.aws.m2.model.GetDataSetDetailsRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val dataSetName: String200 =
      zio.aws.m2.model.primitives.String200(impl.dataSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetDataSetDetailsRequest
  ): zio.aws.m2.model.GetDataSetDetailsRequest.ReadOnly = new Wrapper(impl)
}
