package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatasetDetailOrgAttributes(
    gdg: Optional[zio.aws.m2.model.GdgDetailAttributes] = Optional.Absent,
    po: Optional[zio.aws.m2.model.PoDetailAttributes] = Optional.Absent,
    ps: Optional[zio.aws.m2.model.PsDetailAttributes] = Optional.Absent,
    vsam: Optional[zio.aws.m2.model.VsamDetailAttributes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DatasetDetailOrgAttributes = {
    import DatasetDetailOrgAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DatasetDetailOrgAttributes
      .builder()
      .optionallyWith(gdg.map(value => value.buildAwsValue()))(_.gdg)
      .optionallyWith(po.map(value => value.buildAwsValue()))(_.po)
      .optionallyWith(ps.map(value => value.buildAwsValue()))(_.ps)
      .optionallyWith(vsam.map(value => value.buildAwsValue()))(_.vsam)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DatasetDetailOrgAttributes.ReadOnly =
    zio.aws.m2.model.DatasetDetailOrgAttributes.wrap(buildAwsValue())
}
object DatasetDetailOrgAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DatasetDetailOrgAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DatasetDetailOrgAttributes =
      zio.aws.m2.model.DatasetDetailOrgAttributes(
        gdg.map(value => value.asEditable),
        po.map(value => value.asEditable),
        ps.map(value => value.asEditable),
        vsam.map(value => value.asEditable)
      )
    def gdg: Optional[zio.aws.m2.model.GdgDetailAttributes.ReadOnly]
    def po: Optional[zio.aws.m2.model.PoDetailAttributes.ReadOnly]
    def ps: Optional[zio.aws.m2.model.PsDetailAttributes.ReadOnly]
    def vsam: Optional[zio.aws.m2.model.VsamDetailAttributes.ReadOnly]
    def getGdg
        : ZIO[Any, AwsError, zio.aws.m2.model.GdgDetailAttributes.ReadOnly] =
      AwsError.unwrapOptionField("gdg", gdg)
    def getPo
        : ZIO[Any, AwsError, zio.aws.m2.model.PoDetailAttributes.ReadOnly] =
      AwsError.unwrapOptionField("po", po)
    def getPs
        : ZIO[Any, AwsError, zio.aws.m2.model.PsDetailAttributes.ReadOnly] =
      AwsError.unwrapOptionField("ps", ps)
    def getVsam
        : ZIO[Any, AwsError, zio.aws.m2.model.VsamDetailAttributes.ReadOnly] =
      AwsError.unwrapOptionField("vsam", vsam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DatasetDetailOrgAttributes
  ) extends zio.aws.m2.model.DatasetDetailOrgAttributes.ReadOnly {
    override val gdg: Optional[zio.aws.m2.model.GdgDetailAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gdg())
        .map(value => zio.aws.m2.model.GdgDetailAttributes.wrap(value))
    override val po: Optional[zio.aws.m2.model.PoDetailAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.po())
        .map(value => zio.aws.m2.model.PoDetailAttributes.wrap(value))
    override val ps: Optional[zio.aws.m2.model.PsDetailAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ps())
        .map(value => zio.aws.m2.model.PsDetailAttributes.wrap(value))
    override val vsam
        : Optional[zio.aws.m2.model.VsamDetailAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vsam())
        .map(value => zio.aws.m2.model.VsamDetailAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DatasetDetailOrgAttributes
  ): zio.aws.m2.model.DatasetDetailOrgAttributes.ReadOnly = new Wrapper(impl)
}
