package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{
  Identifier,
  Timestamp,
  Arn,
  Version,
  EntityDescription,
  EntityName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ApplicationSummary(
    applicationArn: Arn,
    applicationId: Identifier,
    applicationVersion: Version,
    creationTime: Timestamp,
    deploymentStatus: Optional[
      zio.aws.m2.model.ApplicationDeploymentLifecycle
    ] = Optional.Absent,
    description: Optional[EntityDescription] = Optional.Absent,
    engineType: zio.aws.m2.model.EngineType,
    environmentId: Optional[Identifier] = Optional.Absent,
    lastStartTime: Optional[Timestamp] = Optional.Absent,
    name: EntityName,
    roleArn: Optional[Arn] = Optional.Absent,
    status: zio.aws.m2.model.ApplicationLifecycle,
    versionStatus: Optional[zio.aws.m2.model.ApplicationVersionLifecycle] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ApplicationSummary
      .builder()
      .applicationArn(Arn.unwrap(applicationArn): java.lang.String)
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .applicationVersion(Version.unwrap(applicationVersion): Integer)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(deploymentStatus.map(value => value.unwrap))(
        _.deploymentStatus
      )
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .engineType(engineType.unwrap)
      .optionallyWith(
        environmentId.map(value => Identifier.unwrap(value): java.lang.String)
      )(_.environmentId)
      .optionallyWith(
        lastStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStartTime)
      .name(EntityName.unwrap(name): java.lang.String)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .status(status.unwrap)
      .optionallyWith(versionStatus.map(value => value.unwrap))(_.versionStatus)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ApplicationSummary.ReadOnly =
    zio.aws.m2.model.ApplicationSummary.wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ApplicationSummary =
      zio.aws.m2.model.ApplicationSummary(
        applicationArn,
        applicationId,
        applicationVersion,
        creationTime,
        deploymentStatus.map(value => value),
        description.map(value => value),
        engineType,
        environmentId.map(value => value),
        lastStartTime.map(value => value),
        name,
        roleArn.map(value => value),
        status,
        versionStatus.map(value => value)
      )
    def applicationArn: Arn
    def applicationId: Identifier
    def applicationVersion: Version
    def creationTime: Timestamp
    def deploymentStatus
        : Optional[zio.aws.m2.model.ApplicationDeploymentLifecycle]
    def description: Optional[EntityDescription]
    def engineType: zio.aws.m2.model.EngineType
    def environmentId: Optional[Identifier]
    def lastStartTime: Optional[Timestamp]
    def name: EntityName
    def roleArn: Optional[Arn]
    def status: zio.aws.m2.model.ApplicationLifecycle
    def versionStatus: Optional[zio.aws.m2.model.ApplicationVersionLifecycle]
    def getApplicationArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(applicationArn)
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getApplicationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(applicationVersion)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getDeploymentStatus
        : ZIO[Any, AwsError, zio.aws.m2.model.ApplicationDeploymentLifecycle] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEngineType: ZIO[Any, Nothing, zio.aws.m2.model.EngineType] =
      ZIO.succeed(engineType)
    def getEnvironmentId: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getLastStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStartTime", lastStartTime)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, Nothing, zio.aws.m2.model.ApplicationLifecycle] =
      ZIO.succeed(status)
    def getVersionStatus
        : ZIO[Any, AwsError, zio.aws.m2.model.ApplicationVersionLifecycle] =
      AwsError.unwrapOptionField("versionStatus", versionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ApplicationSummary
  ) extends zio.aws.m2.model.ApplicationSummary.ReadOnly {
    override val applicationArn: Arn =
      zio.aws.m2.model.primitives.Arn(impl.applicationArn())
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val applicationVersion: Version =
      zio.aws.m2.model.primitives.Version(impl.applicationVersion())
    override val creationTime: Timestamp =
      zio.aws.m2.model.primitives.Timestamp(impl.creationTime())
    override val deploymentStatus
        : Optional[zio.aws.m2.model.ApplicationDeploymentLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatus())
        .map(value =>
          zio.aws.m2.model.ApplicationDeploymentLifecycle.wrap(value)
        )
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.m2.model.primitives.EntityDescription(value))
    override val engineType: zio.aws.m2.model.EngineType =
      zio.aws.m2.model.EngineType.wrap(impl.engineType())
    override val environmentId: Optional[Identifier] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.m2.model.primitives.Identifier(value))
    override val lastStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStartTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val name: EntityName =
      zio.aws.m2.model.primitives.EntityName(impl.name())
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.m2.model.primitives.Arn(value))
    override val status: zio.aws.m2.model.ApplicationLifecycle =
      zio.aws.m2.model.ApplicationLifecycle.wrap(impl.status())
    override val versionStatus
        : Optional[zio.aws.m2.model.ApplicationVersionLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionStatus())
        .map(value => zio.aws.m2.model.ApplicationVersionLifecycle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ApplicationSummary
  ): zio.aws.m2.model.ApplicationSummary.ReadOnly = new Wrapper(impl)
}
